/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.List;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecBase {
    protected String user = null;
    protected String password = null;
    protected int keyIdentifierType = 2;
    protected List<WSEncryptionPart> parts = null;
    protected boolean doDebug = false;
    protected CallbackLookup callbackLookup;
    private WSSConfig wssConfig;

    public WSSecBase() {
    }

    public WSSecBase(WSSConfig config) {
        this.wssConfig = config;
    }

    public void setCallbackLookup(CallbackLookup callbackLookup) {
        this.callbackLookup = callbackLookup;
    }

    public void setParts(List<WSEncryptionPart> parts) {
        this.parts = parts;
    }

    public void setKeyIdentifierType(int keyIdType) {
        this.keyIdentifierType = keyIdType;
    }

    public int getKeyIdentifierType() {
        return this.keyIdentifierType;
    }

    public void setWsConfig(WSSConfig wsConfig) {
        this.wssConfig = wsConfig;
    }

    public WSSConfig getWsConfig() {
        if (this.wssConfig == null) {
            this.wssConfig = WSSConfig.getNewInstance();
        }
        return this.wssConfig;
    }

    protected String setBodyID(Document doc) throws Exception {
        Element bodyElement = WSSecurityUtil.findBodyElement(doc);
        if (bodyElement == null) {
            throw new Exception("SOAP Body Element node not found");
        }
        return this.setWsuId(bodyElement);
    }

    protected String setWsuId(Element bodyElement) {
        String id = bodyElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        String newAttrNs = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        String newAttrPrefix = "wsu";
        if ((id == null || id.length() == 0) && "http://www.w3.org/2001/04/xmlenc#".equals(bodyElement.getNamespaceURI()) && ("EncryptedData".equals(bodyElement.getLocalName()) || "EncryptedKey".equals(bodyElement.getLocalName()))) {
            id = bodyElement.getAttribute("Id");
            newAttrPrefix = "xenc";
            newAttrNs = "http://www.w3.org/2001/04/xmlenc#";
        }
        if (id == null || id.length() == 0) {
            id = this.wssConfig.getIdAllocator().createId("id-", bodyElement);
            String prefix = WSSecurityUtil.setNamespace(bodyElement, newAttrNs, newAttrPrefix);
            bodyElement.setAttributeNS(newAttrNs, prefix + ":Id", id);
        }
        return id;
    }

    public void setUserInfo(String user, String password) {
        this.user = user;
        this.password = password;
    }
}

