/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.spnego;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.spnego.SpnegoServiceAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DefaultSpnegoServiceAction
implements SpnegoServiceAction {
    private static Log log = LogFactory.getLog(DefaultSpnegoServiceAction.class);
    private byte[] ticket;
    private String serviceName;
    private GSSContext secContext;

    @Override
    public void setTicket(byte[] ticket) {
        this.ticket = ticket;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public byte[] run() {
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid oid = new Oid("1.3.6.1.5.5.2");
            GSSName gssService = gssManager.createName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE);
            this.secContext = gssManager.createContext(gssService, oid, null, 0);
            return this.secContext.acceptSecContext(this.ticket, 0, this.ticket.length);
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error in obtaining a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public GSSContext getContext() {
        return this.secContext;
    }
}

