/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class TimestampValidator
implements Validator {
    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getTimestamp() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        if (data.getWssConfig() == null) {
            throw new WSSecurityException("WSSConfig cannot be null");
        }
        WSSConfig wssConfig = data.getWssConfig();
        boolean timeStampStrict = true;
        int timeStampTTL = 300;
        int futureTimeToLive = 60;
        if (wssConfig != null) {
            timeStampStrict = wssConfig.isTimeStampStrict();
            timeStampTTL = wssConfig.getTimeStampTTL();
            futureTimeToLive = wssConfig.getTimeStampFutureTTL();
        }
        Timestamp timeStamp = credential.getTimestamp();
        if (timeStampStrict && timeStamp.isExpired() || !timeStamp.verifyCreated(timeStampTTL, futureTimeToLive)) {
            throw new WSSecurityException(8, "invalidTimestamp", new Object[]{"The security semantics of the message have expired"});
        }
        return credential;
    }
}

