/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.auth;

import java.net.URL;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;

public final class DefaultBasicAuthSupplier
implements HttpAuthSupplier {
    @Override
    public boolean requiresRequestCaching() {
        return false;
    }

    public static String getBasicAuthHeader(String userName, String passwd) {
        String userAndPass = userName + ":" + passwd;
        return "Basic " + Base64Utility.encode((byte[])userAndPass.getBytes());
    }

    @Override
    public String getAuthorization(AuthorizationPolicy authPolicy, URL currentURL, Message message, String fullHeader) {
        if (authPolicy.getUserName() != null && authPolicy.getPassword() != null) {
            return DefaultBasicAuthSupplier.getBasicAuthHeader(authPolicy.getUserName(), authPolicy.getPassword());
        }
        return null;
    }
}

