/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.ejbql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jboss.as.cmp.ejbql.SelectFunction;
import org.jboss.as.cmp.ejbql.SimpleNode;
import org.jboss.as.cmp.jdbc.JDBCResultSetReader;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.logging.Logger;

public abstract class AbstractMappedTypeFunction
extends SimpleNode
implements SelectFunction {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected Class<?> resultType;
    protected JDBCResultSetReader resultReader;

    public AbstractMappedTypeFunction(int i) {
        super(i);
    }

    public void setResultType(Class<?> type) {
        this.resultType = Collection.class.isAssignableFrom(type) ? this.getDefaultResultType() : type;
        this.resultReader = JDBCUtil.getResultReaderByType(this.resultType);
    }

    protected Class<?> getDefaultResultType() {
        return Double.class;
    }

    public void setJDBCType(final JDBCType jdbcType) {
        if (this.resultReader != null) {
            final JDBCResultSetReader jdbcResultReader = this.resultReader;
            this.resultReader = new JDBCResultSetReader(){

                public Object get(ResultSet rs, int index, Class destination, Logger log) throws SQLException {
                    Object jdbcResult = jdbcResultReader.get(rs, index, destination, log);
                    return jdbcType.setColumnValue(0, null, jdbcResult);
                }
            };
        }
    }

    @Override
    public Object readResult(ResultSet rs) throws SQLException {
        return this.resultReader.get(rs, 1, this.resultType, this.log);
    }
}

