/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import javax.ejb.RemoveException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.logging.Logger;

public final class JDBCRemoveEntityCommand {
    private final JDBCStoreManager manager;
    private final JDBCEntityBridge entity;
    private final Logger log;
    private final String removeEntitySQL;
    private final boolean syncOnCommitOnly;
    private boolean batchCascadeDelete;

    public JDBCRemoveEntityCommand(JDBCStoreManager manager) {
        this.manager = manager;
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
        SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), sql);
        this.removeEntitySQL = sql.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Remove SQL: " + this.removeEntitySQL));
        }
        this.syncOnCommitOnly = manager.getCmpConfig().isSyncOnCommitOnly();
        JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])this.entity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            if (!cmrFields[i].isBatchCascadeDelete()) continue;
            this.batchCascadeDelete = true;
            break;
        }
    }

    public void execute(CmpEntityBeanContext ctx) throws RemoveException, RemoteException {
        if (this.entity.isRemoved(ctx)) {
            throw CmpMessages.MESSAGES.instanceAlreadyRemoved(ctx.getPrimaryKey());
        }
        this.entity.setIsBeingRemoved(ctx);
        Object[] oldRelationsRef = new Object[1];
        boolean needsSync = this.entity.removeFromRelations(ctx, oldRelationsRef);
        if (!this.syncOnCommitOnly && needsSync) {
            ctx.getComponent().synchronizeEntitiesWithinTransaction(ctx.getTransaction());
        }
        if (!this.batchCascadeDelete) {
            if (!this.entity.isScheduledForBatchCascadeDelete(ctx)) {
                this.executeDeleteSQL(ctx);
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Instance is scheduled for cascade delete. id=" + ctx.getPrimaryKey()));
            }
        }
        if (oldRelationsRef[0] != null) {
            Map oldRelations = (Map)oldRelationsRef[0];
            this.entity.cascadeDelete(ctx, oldRelations);
        }
        if (this.batchCascadeDelete) {
            if (!this.entity.isScheduledForBatchCascadeDelete(ctx)) {
                this.executeDeleteSQL(ctx);
            } else if (this.log.isTraceEnabled()) {
                this.log.debug((Object)("Instance is scheduled for cascade delete. id=" + ctx.getPrimaryKey()));
            }
        }
        this.manager.getReadAheadCache().removeCachedData(ctx.getPrimaryKey());
        this.entity.setRemoved(ctx);
    }

    private void executeDeleteSQL(CmpEntityBeanContext ctx) throws RemoveException {
        Object key = ctx.getPrimaryKey();
        Connection con = null;
        PreparedStatement ps = null;
        int rowsAffected = 0;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + this.removeEntitySQL));
            }
            con = this.entity.getDataSource().getConnection();
            ps = con.prepareStatement(this.removeEntitySQL);
            this.entity.setPrimaryKeyParameters(ps, 1, key);
            rowsAffected = ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw CmpMessages.MESSAGES.couldNotRemoveEntity(key, e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        if (rowsAffected == 0) {
            throw CmpMessages.MESSAGES.couldNotRemoveEntityNoRows(key);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Remove: Rows affected = " + rowsAffected));
        }
    }
}

