/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2.keygen;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.CreateException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc2.CreateCommand;
import org.jboss.as.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.as.cmp.jdbc2.PersistentContext;
import org.jboss.as.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.as.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.logging.Logger;

public abstract class AbstractCreateCommand
implements CreateCommand {
    protected JDBCEntityBridge2 entityBridge;
    protected Logger log;
    protected JDBCCMPFieldBridge2 pkField;
    protected String pkSql;

    @Override
    public void init(JDBCStoreManager2 manager) {
        this.entityBridge = (JDBCEntityBridge2)manager.getEntityBridge();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.entityBridge.getEntityName()));
        JDBCFieldBridge[] pkFields = this.entityBridge.getPrimaryKeyFields();
        if (pkFields.length > 1) {
            throw CmpMessages.MESSAGES.entityCommandCanNotBeUsedWithCompositePk();
        }
        this.pkField = (JDBCCMPFieldBridge2)pkFields[0];
        this.pkSql = "";
    }

    @Override
    public Object execute(Method m, Object[] args, CmpEntityBeanContext ctx) throws CreateException {
        Object pk;
        block12: {
            PersistentContext pctx;
            block10: {
                pctx = (PersistentContext)ctx.getPersistenceContext();
                if (ctx.getPrimaryKey() != null) break block10;
                Connection con = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("executing sql: " + this.pkSql));
                    }
                    if (!(rs = (ps = (con = this.entityBridge.getDataSource().getConnection()).prepareStatement(this.pkSql)).executeQuery()).next()) {
                        throw CmpMessages.MESSAGES.pkSqlReturnedNoResults(this.pkSql);
                    }
                    pk = this.pkField.loadArgumentResults(rs, 1);
                    pctx.setFieldValue(this.pkField.getRowIndex(), pk);
                    pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
                }
                catch (SQLException e) {
                    try {
                        throw CmpMessages.MESSAGES.failedToExecutePkSql(e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose(rs);
                        JDBCUtil.safeClose(ps);
                        JDBCUtil.safeClose(con);
                        throw throwable;
                    }
                }
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                if (pk == null) {
                    throw CmpMessages.MESSAGES.pkIsNullForCreatedInstance();
                }
                pctx.setPk(pk);
                break block12;
            }
            try {
                pctx.flush();
            }
            catch (SQLException e) {
                if ("23000".equals(e.getSQLState())) {
                    throw CmpMessages.MESSAGES.uniqueKeyViolation(ctx.getPrimaryKey());
                }
                throw CmpMessages.MESSAGES.failedToCreateInstance(ctx.getPrimaryKey(), e);
            }
            pk = ctx.getPrimaryKey();
        }
        return pk;
    }
}

