/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.cmp.subsystem.Attribute;
import org.jboss.as.cmp.subsystem.CmpConstants;
import org.jboss.as.cmp.subsystem.Element;
import org.jboss.as.cmp.subsystem.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class CmpSubsystem10Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static CmpSubsystem10Parser INSTANCE = new CmpSubsystem10Parser();

    private CmpSubsystem10Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "cmp");
        address.protect();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode cmpSubsystem = new ModelNode();
        cmpSubsystem.get("operation").set("add");
        cmpSubsystem.get("address").set(address);
        operations.add(cmpSubsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_GENERATORS: {
                    this.parseKeyGenerators(reader, operations, address);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyGenerators(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode parentAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case UUID: {
                    operations.add(this.parseUuid(reader, parentAddress));
                    continue block4;
                }
                case HILO: {
                    operations.add(this.parseHilo(reader, parentAddress));
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseUuid(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        ModelNode address = parentAddress.clone();
        address.add(CmpConstants.UUID_KEY_GENERATOR, name);
        address.protect();
        op.get("address").set(address);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return op;
    }

    private ModelNode parseHilo(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        ModelNode address = parentAddress.clone();
        address.add(CmpConstants.HILO_KEY_GENERATOR, name);
        address.protect();
        op.get("address").set(address);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            String value = reader.getElementText();
            switch (Element.forName(reader.getLocalName())) {
                case BLOCK_SIZE: {
                    op.get(CmpConstants.BLOCK_SIZE).set(Long.parseLong(value));
                    continue block16;
                }
                case CREATE_TABLE: {
                    op.get(CmpConstants.CREATE_TABLE).set(Boolean.parseBoolean(value));
                    continue block16;
                }
                case CREATE_TABLE_DDL: {
                    op.get(CmpConstants.CREATE_TABLE_DDL).set(value);
                    continue block16;
                }
                case DATA_SOURCE: {
                    op.get(CmpConstants.DATA_SOURCE).set(value);
                    continue block16;
                }
                case DROP_TABLE: {
                    op.get(CmpConstants.DROP_TABLE).set(Boolean.parseBoolean(value));
                    continue block16;
                }
                case ID_COLUMN: {
                    op.get(CmpConstants.ID_COLUMN).set(value);
                    continue block16;
                }
                case SELECT_HI_DDL: {
                    op.get(CmpConstants.SELECT_HI_DDL).set(value);
                    continue block16;
                }
                case SEQUENCE_COLUMN: {
                    op.get(CmpConstants.SEQUENCE_COLUMN).set(value);
                    continue block16;
                }
                case SEQUENCE_NAME: {
                    op.get(CmpConstants.SEQUENCE_NAME).set(value);
                    continue block16;
                }
                case TABLE_NAME: {
                    op.get(CmpConstants.TABLE_NAME).set(value);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return op;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CMP_1_0.getUriString(), false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined(CmpConstants.UUID_KEY_GENERATOR) || model.hasDefined(CmpConstants.HILO_KEY_GENERATOR)) {
            String name;
            writer.writeStartElement(Element.KEY_GENERATORS.getLocalName());
            if (model.hasDefined(CmpConstants.UUID_KEY_GENERATOR)) {
                for (Property keyGen : model.get(CmpConstants.UUID_KEY_GENERATOR).asPropertyList()) {
                    name = keyGen.getName();
                    this.writeUuid(writer, name);
                }
            }
            if (model.hasDefined(CmpConstants.HILO_KEY_GENERATOR)) {
                for (Property keyGen : model.get(CmpConstants.HILO_KEY_GENERATOR).asPropertyList()) {
                    name = keyGen.getName();
                    ModelNode keyGenModel = keyGen.getValue();
                    this.writeHilo(writer, name, keyGenModel);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeHilo(XMLExtendedStreamWriter writer, String name, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.HILO.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        if (model.hasDefined(CmpConstants.BLOCK_SIZE)) {
            writer.writeStartElement(Element.BLOCK_SIZE.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.BLOCK_SIZE).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.CREATE_TABLE)) {
            writer.writeStartElement(Element.CREATE_TABLE.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.CREATE_TABLE).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.CREATE_TABLE_DDL)) {
            writer.writeStartElement(Element.CREATE_TABLE_DDL.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.CREATE_TABLE_DDL).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.DATA_SOURCE)) {
            writer.writeStartElement(Element.DATA_SOURCE.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.DATA_SOURCE).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.DROP_TABLE)) {
            writer.writeStartElement(Element.DROP_TABLE.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.DROP_TABLE).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.ID_COLUMN)) {
            writer.writeStartElement(Element.ID_COLUMN.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.ID_COLUMN).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.SELECT_HI_DDL)) {
            writer.writeStartElement(Element.SELECT_HI_DDL.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.SELECT_HI_DDL).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.SEQUENCE_COLUMN)) {
            writer.writeStartElement(Element.SEQUENCE_COLUMN.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.SEQUENCE_COLUMN).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.SEQUENCE_NAME)) {
            writer.writeStartElement(Element.SEQUENCE_NAME.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.SEQUENCE_NAME).asString());
            writer.writeEndElement();
        }
        if (model.hasDefined(CmpConstants.TABLE_NAME)) {
            writer.writeStartElement(Element.TABLE_NAME.getLocalName());
            writer.writeCharacters(model.get(CmpConstants.TABLE_NAME).asString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeUuid(XMLExtendedStreamWriter writer, String name) throws XMLStreamException {
        writer.writeStartElement(Element.UUID.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        writer.writeEndElement();
    }
}

