/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.slf4j.Logger;

public class ParsedIOR {
    private Profile effectiveProfile = null;
    private final List profiles = new ArrayList();
    private TaggedComponentList components = new TaggedComponentList();
    private ProfileSelector profileSelector;
    protected boolean endianness = false;
    private String ior_str = null;
    private IOR ior = null;
    private final ORB orb;
    private CodeSetComponentInfo cs_info = null;
    private Integer orbTypeId = null;
    private final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOR createObjectIOR(Profile profile) {
        String string = "IDL:omg.org/CORBA/Object:1.0";
        TaggedComponentList taggedComponentList = new TaggedComponentList();
        CDROutputStream cDROutputStream = new CDROutputStream();
        try {
            cDROutputStream.beginEncapsulatedArray();
            cDROutputStream.write_long(1245790976);
            taggedComponentList.addComponent(new TaggedComponent(0, cDROutputStream.getBufferCopy()));
        }
        finally {
            cDROutputStream.close();
        }
        ArrayList<TaggedProfile> arrayList = new ArrayList<TaggedProfile>();
        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
        TaggedComponentSeqHolder taggedComponentSeqHolder = new TaggedComponentSeqHolder();
        taggedComponentSeqHolder.value = taggedComponentList.asArray();
        profile.marshal(taggedProfileHolder, taggedComponentSeqHolder);
        arrayList.add(taggedProfileHolder.value);
        TaggedProfile[] taggedProfileArray = new TaggedProfile[arrayList.size()];
        arrayList.toArray(taggedProfileArray);
        return new IOR(string, taggedProfileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOR createObjectIOR(Profile[] profileArray) {
        String string = "IDL:omg.org/CORBA/Object:1.0";
        ArrayList<TaggedProfile> arrayList = new ArrayList<TaggedProfile>();
        for (int i = 0; i < profileArray.length; ++i) {
            if (profileArray[i] == null) continue;
            TaggedComponentList taggedComponentList = new TaggedComponentList();
            CDROutputStream cDROutputStream = new CDROutputStream();
            try {
                cDROutputStream.beginEncapsulatedArray();
                cDROutputStream.write_long(1245790976);
                taggedComponentList.addComponent(new TaggedComponent(0, cDROutputStream.getBufferCopy()));
            }
            finally {
                cDROutputStream.close();
            }
            TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
            TaggedComponentSeqHolder taggedComponentSeqHolder = new TaggedComponentSeqHolder();
            taggedComponentSeqHolder.value = taggedComponentList.asArray();
            profileArray[i].marshal(taggedProfileHolder, taggedComponentSeqHolder);
            arrayList.add(taggedProfileHolder.value);
        }
        TaggedProfile[] taggedProfileArray = new TaggedProfile[arrayList.size()];
        arrayList.toArray(taggedProfileArray);
        return new IOR(string, taggedProfileArray);
    }

    public static byte[] extractObjectKey(TargetAddress targetAddress, ORB oRB) {
        java.lang.Object object;
        TaggedProfile taggedProfile = null;
        switch (targetAddress.discriminator()) {
            case 0: {
                return targetAddress.object_key();
            }
            case 1: {
                taggedProfile = new TaggedProfile(targetAddress.profile().tag, targetAddress.profile().profile_data);
                break;
            }
            case 2: {
                object = targetAddress.ior();
                taggedProfile = new TaggedProfile(((IORAddressingInfo)object).ior.profiles[((IORAddressingInfo)object).selected_profile_index].tag, ((IORAddressingInfo)object).ior.profiles[((IORAddressingInfo)object).selected_profile_index].profile_data);
                break;
            }
            default: {
                throw new BAD_PARAM("Invalid value for TargetAddress discriminator");
            }
        }
        object = new TaggedProfileHolder(taggedProfile);
        Factories factories = oRB.getTransportManager().getFactories(taggedProfile.tag);
        if (factories != null) {
            return factories.demarshal_profile((TaggedProfileHolder)object, new TaggedComponentSeqHolder()).get_object_key();
        }
        return null;
    }

    public String getCodebaseComponent() {
        return this.getStringComponent(25);
    }

    private ParsedIOR(ORB oRB) {
        this.orb = oRB;
        this.logger = this.orb.getConfiguration().getLogger("jacorb.orb.parsedior");
    }

    public ParsedIOR(ORB oRB, String string) throws IllegalArgumentException {
        this(oRB);
        this.parse(string);
    }

    public ParsedIOR(ORB oRB, IOR iOR) {
        this(oRB);
        this.decode(iOR);
    }

    public boolean equals(java.lang.Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof ParsedIOR && ((ParsedIOR)object).getIORString().equals(this.getIORString()) && this.effectiveProfile != null && this.effectiveProfile.is_match(((ParsedIOR)object).effectiveProfile);
    }

    public int hashCode() {
        return this.getIORString().hashCode();
    }

    public void decode(IOR iOR) {
        block3: for (int i = 0; i < iOR.profiles.length; ++i) {
            int n = iOR.profiles[i].tag;
            switch (n) {
                case 1: {
                    this.components = new TaggedComponentList(iOR.profiles[i].profile_data);
                    continue block3;
                }
                default: {
                    Factories factories = this.orb.getTransportManager().getFactories(n);
                    if (factories != null) {
                        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder(iOR.profiles[i]);
                        this.profiles.add(factories.demarshal_profile(taggedProfileHolder, new TaggedComponentSeqHolder()));
                        continue block3;
                    }
                    if (!this.logger.isDebugEnabled()) continue block3;
                    this.logger.debug("No transport available for profile tag " + n);
                    continue block3;
                }
            }
        }
        this.ior = iOR;
        this.setEffectiveProfile();
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs_info;
    }

    public Integer getORBTypeId() {
        return this.orbTypeId;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
                cDROutputStream.beginEncapsulatedArray();
                IORHelper.write(cDROutputStream, this.ior);
                byte[] byArray = cDROutputStream.getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                for (int i = 0; i < byArray.length; ++i) {
                    ObjectUtil.appendHex(stringBuffer, byArray[i] >> 4 & 0xF);
                    ObjectUtil.appendHex(stringBuffer, byArray[i] & 0xF);
                }
                this.ior_str = stringBuffer.toString();
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Error in building IIOP-IOR", (Throwable)exception);
                }
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    public byte[] get_object_key() {
        return this.effectiveProfile.get_object_key();
    }

    public List getProfiles() {
        return this.profiles;
    }

    public Profile getEffectiveProfile() {
        return this.effectiveProfile;
    }

    private void setEffectiveProfile() {
        this.effectiveProfile = this.getProfileSelector().selectProfile(this.profiles, this.orb.getClientConnectionManager());
        this.ior_str = this.getIORString();
        if (this.effectiveProfile != null) {
            this.cs_info = (CodeSetComponentInfo)this.getComponent(1, CodeSetComponentInfoHelper.class);
            this.orbTypeId = this.getLongComponent(0);
        }
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public String getIDString() {
        StringBuffer stringBuffer = new StringBuffer(this.getTypeId());
        stringBuffer.append(":");
        byte[] byArray = this.get_object_key();
        for (int i = 0; i < byArray.length; ++i) {
            ObjectUtil.appendHex(stringBuffer, byArray[i] >> 4 & 0xF);
            ObjectUtil.appendHex(stringBuffer, byArray[i] & 0xF);
        }
        return stringBuffer.toString();
    }

    public TaggedComponentList getMultipleComponents() {
        return this.components;
    }

    public boolean isNull() {
        return "".equals(this.ior.type_id) && this.ior.profiles.length == 0;
    }

    protected void parse(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null object reference");
        }
        if (string.startsWith("IOR:")) {
            this.parse_stringified_ior(string);
        } else if (string.startsWith("corbaloc:")) {
            this.parse_corbaloc(string);
        } else if (string.startsWith("corbaname:")) {
            this.parse_corbaname(string);
        } else if (string.startsWith("resource:")) {
            this.parse_resource(string.substring(9));
        } else if (string.startsWith("jndi:")) {
            this.parse_jndi(string.substring(5));
        } else {
            String string2;
            block15: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to resolve URL/IOR from: " + string);
                }
                string2 = null;
                try {
                    string2 = ObjectUtil.readURL(string);
                }
                catch (IOException iOException) {
                    if (!this.logger.isDebugEnabled()) break block15;
                    this.logger.debug("Error reading IOR/URL: ", (Throwable)iOException);
                }
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Invalid or unreadable URL/IOR: " + string);
            }
            this.parse(string2);
        }
        this.ior_str = this.getIORString();
    }

    private void parse_stringified_ior(String string) {
        int n = string.length();
        int n2 = (n - 4) / 2;
        if (n % 2 != 0) {
            throw new BAD_PARAM("Odd number of characters within object reference");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n2; ++i) {
            int n3;
            char c = string.charAt(i * 2 + 4);
            char c2 = string.charAt(i * 2 + 5);
            int n4 = c >= 'a' ? 10 + c - 97 : (n3 = c >= 'A' ? 10 + c - 65 : c - 48);
            int n5 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
            byteArrayOutputStream.write(n3 * 16 + n5);
        }
        CDRInputStream cDRInputStream = this.orb == null ? new CDRInputStream(org.omg.CORBA.ORB.init(), byteArrayOutputStream.toByteArray()) : new CDRInputStream(this.orb, byteArrayOutputStream.toByteArray());
        this.endianness = cDRInputStream.read_boolean();
        if (this.endianness) {
            cDRInputStream.setLittleEndian(true);
        }
        try {
            IOR iOR = IORHelper.read(cDRInputStream);
            this.decode(iOR);
        }
        catch (MARSHAL mARSHAL) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid IOR", (Throwable)mARSHAL);
            }
            throw new BAD_PARAM("Invalid IOR " + mARSHAL, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parse_corbaloc(String string) {
        CorbaLoc corbaLoc = new CorbaLoc(this.orb, string);
        IOR iOR = null;
        if (corbaLoc.rir()) {
            try {
                Object object = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                if (object == null) {
                    throw new IllegalArgumentException("Unable to resolve reference for " + corbaLoc.getKeyString());
                }
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(exception.getMessage());
                }
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else {
            if (corbaLoc.profileList.length == 0) {
                return;
            }
            for (int i = 0; i < corbaLoc.profileList.length; ++i) {
                corbaLoc.profileList[i].set_object_key(corbaLoc.getKey());
            }
            iOR = ParsedIOR.createObjectIOR(corbaLoc.profileList);
        }
        this.decode(iOR);
    }

    private void parse_corbaname(String string) {
        String string2 = "corbaloc:";
        String string3 = "";
        int n = string.indexOf(58);
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            string2 = string2 + string.substring(n + 1);
        } else {
            string2 = string2 + string.substring(n + 1, n2);
            string3 = string.substring(n2 + 1);
        }
        if (string2.indexOf(47) == -1) {
            string2 = string2 + "/NameService";
        }
        this.logger.debug(string2);
        try {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.orb.string_to_object(string2));
            IOR iOR = null;
            if (string3.length() > 0) {
                Object object = namingContextExt.resolve_str(string3);
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            } else {
                iOR = ((Delegate)((ObjectImpl)((java.lang.Object)namingContextExt))._get_delegate()).getIOR();
            }
            this.decode(iOR);
        }
        catch (Exception exception) {
            this.logger.error("Invalid object reference", (Throwable)exception);
            throw new IllegalArgumentException("Invalid object reference: " + string);
        }
    }

    private void parse_resource(String string) {
        URL uRL;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve URL/IOR from resource: " + string);
        }
        if ((uRL = ObjectUtil.getResource(string)) == null) {
            throw new IllegalArgumentException("Failed to get resource: " + string);
        }
        try {
            String string2 = ObjectUtil.readURL(uRL.toString());
            this.parse(string2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read resource: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse_jndi(String string) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to resolve JNDI/IOR from name: " + string);
        }
        try {
            InitialContext initialContext = new InitialContext();
            try {
                java.lang.Object object = initialContext.lookup(string);
                if (object == null) {
                    throw new IllegalArgumentException("Null JNDI/IOR: " + string);
                }
                this.parse(object.toString());
            }
            finally {
                initialContext.close();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to lookup JNDI/IOR: " + exception);
        }
    }

    private java.lang.Object getComponent(int n, Class clazz) {
        java.lang.Object object = null;
        if (this.effectiveProfile instanceof ProfileBase) {
            object = ((ProfileBase)this.effectiveProfile).getComponent(n, clazz);
        }
        if (object != null) {
            return object;
        }
        return this.components.getComponent(n, clazz);
    }

    private Integer getLongComponent(int n) {
        return (Integer)this.getComponent(n, LongHelper.class);
    }

    private String getStringComponent(int n) {
        return (String)this.getComponent(n, StringHelper.class);
    }

    public static boolean isParsableProtocol(String string) {
        return string.startsWith("IOR:") || string.startsWith("corbaloc:") || string.startsWith("corbaname:") || string.startsWith("resource:") || string.startsWith("jndi:") || string.startsWith("file:") || string.startsWith("http:");
    }

    public void setProfileSelector(ProfileSelector profileSelector) {
        this.profileSelector = profileSelector;
        this.setEffectiveProfile();
    }

    private ProfileSelector getProfileSelector() {
        if (this.profileSelector == null) {
            return this.orb.getTransportManager().getProfileSelector();
        }
        return this.profileSelector;
    }

    private static class StringHelper {
        private StringHelper() {
        }

        public static String read(InputStream inputStream) {
            return inputStream.read_string();
        }
    }

    private static class LongHelper {
        private LongHelper() {
        }

        public static Integer read(InputStream inputStream) {
            return new Integer(inputStream.read_long());
        }
    }
}

