/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.omg.CORBA.BAD_PARAM;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.slf4j.Logger;

public class ClientConnectionManager
implements Configurable {
    private final ORB orb;
    private final Map connections = new HashMap();
    private RequestListener request_listener;
    private MessageReceptorPool receptor_pool;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;
    private Logger logger;

    public ClientConnectionManager(ORB oRB, TransportManager transportManager, GIOPConnectionManager gIOPConnectionManager) {
        this.orb = oRB;
        this.transport_manager = transportManager;
        this.giop_connection_manager = gIOPConnectionManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.receptor_pool = new MessageReceptorPool("client", "ClientMessageReceptor", configuration);
        Configuration configuration2 = configuration;
        this.logger = configuration2.getLogger("jacorb.orb.giop");
        this.request_listener = new NoBiDirClientRequestListener(this.orb, this.logger);
    }

    public void setRequestListener(RequestListener requestListener) {
        this.request_listener = requestListener;
    }

    public synchronized ClientConnection getConnection(Profile profile) {
        ClientConnection clientConnection = (ClientConnection)this.connections.get(profile);
        if (clientConnection == null) {
            int n = profile.tag();
            Factories factories = this.transport_manager.getFactories(n);
            if (factories == null) {
                throw new BAD_PARAM("No transport plugin for profile tag " + n);
            }
            GIOPConnection gIOPConnection = this.giop_connection_manager.createClientGIOPConnection(profile, factories.create_connection(null), this.request_listener, null);
            clientConnection = new ClientConnection(gIOPConnection, this.orb, this, profile, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ClientConnectionManager: created new " + clientConnection.getGIOPConnection().toString());
            }
            this.receptor_pool.connectionCreated(gIOPConnection);
            this.connections.put(profile, clientConnection);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("ClientConnectionManager: found " + clientConnection.getGIOPConnection().toString());
        }
        clientConnection.incClients();
        return clientConnection;
    }

    public synchronized void releaseConnection(ClientConnection clientConnection) {
        if (clientConnection.decClients()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ClientConnectionManager: releasing " + clientConnection.getGIOPConnection().toString());
            }
            clientConnection.close();
            this.connections.remove(clientConnection.getRegisteredProfile());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager: cannot release " + clientConnection.getGIOPConnection().toString() + " (still has " + clientConnection.numClients() + " client(s))");
        }
    }

    public synchronized void removeConnection(ClientConnection clientConnection) {
        this.connections.remove(clientConnection.getRegisteredProfile());
    }

    public synchronized void addConnection(GIOPConnection gIOPConnection, Profile profile) {
        if (!this.connections.containsKey(profile)) {
            ClientConnection clientConnection = new ClientConnection(gIOPConnection, this.orb, this, profile, false);
            clientConnection.incClients();
            this.connections.put(profile, clientConnection);
        }
    }

    public synchronized void shutdown() {
        Iterator iterator = new HashSet(this.connections.values()).iterator();
        while (iterator.hasNext()) {
            ((ClientConnection)iterator.next()).close();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager shut down (all connections released)");
        }
        this.connections.clear();
        this.receptor_pool.shutdown();
    }
}

