/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.MARSHAL;
import org.omg.IOP.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeSet {
    private static final CodeSet ISO8859_1_CODESET = new Iso8859_1CodeSet();
    private static final CodeSet UTF8_CODESET = new Utf8CodeSet();
    private static final CodeSet UTF16_CODESET = new Utf16CodeSet();
    private static final CodeSet UCS2_CODESET = new Ucs2CodeSet();
    private static final CodeSet NULL_CODE_SET = new CodeSet(-1, "NO SUCH CODESET");
    private static CodeSet[] KNOWN_ENCODINGS = new CodeSet[]{ISO8859_1_CODESET, UTF16_CODESET, UTF8_CODESET, UCS2_CODESET};
    private static Logger logger = LoggerFactory.getLogger((String)"jacorb.codeset");
    private static boolean isConfigured = false;
    private static CodeSet nativeCodeSetChar = null;
    private static CodeSet nativeCodeSetWchar = UTF16_CODESET;
    private static CodeSetComponentInfo localCodeSetComponentInfo;
    private int id;
    private String name;
    private static final String CODESET_PREFIX = "0x00000000";

    public static String csName(int n) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (n != KNOWN_ENCODINGS[i].getId()) continue;
            return KNOWN_ENCODINGS[i].getName();
        }
        return "Unknown TCS: " + CodeSet.toCodeSetString(n);
    }

    public static synchronized void configure(Configuration configuration) throws ConfigurationException {
        if (!isConfigured) {
            CodeSet codeSet;
            String string = configuration.getAttribute("jacorb.native_char_codeset", "");
            String string2 = configuration.getAttribute("jacorb.native_wchar_codeset", "");
            if (string != null && !"".equals(string)) {
                codeSet = CodeSet.getCodeSet(string);
                if (codeSet != NULL_CODE_SET) {
                    nativeCodeSetChar = codeSet;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSC to " + string);
                }
            }
            if (string2 != null && !"".equals(string2)) {
                codeSet = CodeSet.getCodeSet(string);
                if (codeSet != NULL_CODE_SET) {
                    nativeCodeSetWchar = codeSet;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSW to " + string2);
                }
            }
            logger = configuration.getLogger("jacorb.codeset");
            isConfigured = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("CodeSet is already configured; further attempts to reconfigure will be ignored!");
        }
    }

    public static CodeSet getCodeSet(String string) {
        int n;
        String string2 = string.toUpperCase();
        for (n = 0; n < KNOWN_ENCODINGS.length; ++n) {
            CodeSet codeSet = KNOWN_ENCODINGS[n];
            if (!codeSet.getName().equals(string2)) continue;
            return codeSet;
        }
        try {
            n = Integer.parseInt(string, 16);
            for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
                CodeSet codeSet = KNOWN_ENCODINGS[i];
                if (n != codeSet.getId()) continue;
                return codeSet;
            }
            return NULL_CODE_SET;
        }
        catch (NumberFormatException numberFormatException) {
            return NULL_CODE_SET;
        }
    }

    public static CodeSet getCodeSet(int n) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeSet = KNOWN_ENCODINGS[i];
            if (n != codeSet.id) continue;
            return codeSet;
        }
        return NULL_CODE_SET;
    }

    public static CodeSet getTCSDefault() {
        if (nativeCodeSetChar != null) {
            return nativeCodeSetChar;
        }
        String string = CodeSet.getDefaultEncoding();
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeSet = KNOWN_ENCODINGS[i];
            if (!codeSet.supportsCharacterData(false) || !string.equals(codeSet.getName())) continue;
            return CodeSet.setNativeCodeSetChar(codeSet);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Warning - unknown codeset (" + string + ") - defaulting to ISO-8859-1");
        }
        return CodeSet.setNativeCodeSetChar(ISO8859_1_CODESET);
    }

    private static CodeSet setNativeCodeSetChar(CodeSet codeSet) {
        nativeCodeSetChar = codeSet;
        if (logger.isDebugEnabled()) {
            logger.debug("TCS set to " + codeSet.getName());
        }
        return codeSet;
    }

    private static String getDefaultEncoding() {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new ByteArrayOutputStream());
        String string = outputStreamWriter.getEncoding();
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static CodeSet getTCSWDefault() {
        return nativeCodeSetWchar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext createCodesetContext(CodeSet codeSet, CodeSet codeSet2) {
        CDROutputStream cDROutputStream = new CDROutputStream();
        try {
            cDROutputStream.beginEncapsulatedArray();
            CodeSetContextHelper.write(cDROutputStream, new CodeSetContext(codeSet.getId(), codeSet2.getId()));
            ServiceContext serviceContext = new ServiceContext(1, cDROutputStream.getBufferCopy());
            return serviceContext;
        }
        finally {
            cDROutputStream.close();
        }
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != 1) continue;
            CDRInputStream cDRInputStream = new CDRInputStream(null, serviceContextArray[i].context_data);
            cDRInputStream.openEncapsulatedArray();
            return CodeSetContextHelper.read(cDRInputStream);
        }
        return null;
    }

    public static CodeSetComponentInfo getLocalCodeSetComponentInfo() {
        if (localCodeSetComponentInfo == null) {
            localCodeSetComponentInfo = new CodeSetComponentInfo();
            CodeSet.localCodeSetComponentInfo.ForCharData = CodeSet.createCodeSetComponent(false, CodeSet.getTCSDefault());
            CodeSet.localCodeSetComponentInfo.ForWcharData = CodeSet.createCodeSetComponent(true, CodeSet.getTCSWDefault());
        }
        return localCodeSetComponentInfo;
    }

    private static CodeSetComponent createCodeSetComponent(boolean bl, CodeSet codeSet) {
        int n;
        ArrayList<CodeSet> arrayList = new ArrayList<CodeSet>();
        arrayList.add(codeSet);
        for (n = 0; n < KNOWN_ENCODINGS.length; ++n) {
            if (!KNOWN_ENCODINGS[n].supportsCharacterData(bl) || arrayList.contains(KNOWN_ENCODINGS[n])) continue;
            arrayList.add(KNOWN_ENCODINGS[n]);
        }
        n = ((CodeSet)arrayList.remove(0)).getId();
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((CodeSet)arrayList.get(i)).getId();
        }
        return new CodeSetComponent(n, nArray);
    }

    public static CodeSet getNegotiatedCodeSet(CodeSetComponentInfo codeSetComponentInfo, boolean bl) {
        return CodeSet.getMatchingCodeSet(CodeSet.getSelectedComponent(CodeSet.getLocalCodeSetComponentInfo(), bl), CodeSet.getSelectedComponent(codeSetComponentInfo, bl), bl);
    }

    public static CodeSet getMatchingCodeSet(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2, boolean bl) {
        CodeSet codeSet = CodeSet.getCodeSetIfMatched(codeSetComponent.native_code_set, codeSetComponent2);
        if (codeSet != null) {
            return codeSet;
        }
        for (int i = 0; i < codeSetComponent.conversion_code_sets.length; ++i) {
            codeSet = CodeSet.getCodeSetIfMatched(codeSetComponent.conversion_code_sets[i], codeSetComponent2);
            if (codeSet == null) continue;
            return codeSet;
        }
        return CodeSet.reportNegotiationFailure(codeSetComponent, codeSetComponent2, bl);
    }

    public static CodeSet getCodeSetIfMatched(int n, CodeSetComponent codeSetComponent) {
        if (n == codeSetComponent.native_code_set) {
            return CodeSet.getCodeSet(n);
        }
        for (int i = 0; i < codeSetComponent.conversion_code_sets.length; ++i) {
            if (n != codeSetComponent.conversion_code_sets[i]) continue;
            return CodeSet.getCodeSet(n);
        }
        return null;
    }

    private static CodeSet reportNegotiationFailure(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("No matching ");
        if (bl) {
            stringBuffer.append("wide ");
        }
        stringBuffer.append("code set found. Client knows {");
        CodeSet.appendCodeSetList(stringBuffer, codeSetComponent);
        stringBuffer.append("}. Server offered {");
        CodeSet.appendCodeSetList(stringBuffer, codeSetComponent2);
        stringBuffer.append('}');
        throw new CODESET_INCOMPATIBLE(stringBuffer.toString());
    }

    private static void appendCodeSetList(StringBuffer stringBuffer, CodeSetComponent codeSetComponent) {
        int n = codeSetComponent.native_code_set;
        stringBuffer.append(CodeSet.toCodeSetString(n));
        for (int i = 0; i < codeSetComponent.conversion_code_sets.length; ++i) {
            stringBuffer.append(',').append(CodeSet.toCodeSetString(codeSetComponent.conversion_code_sets[i]));
        }
    }

    private static String toCodeSetString(int n) {
        String string = Integer.toHexString(n);
        return CODESET_PREFIX.substring(0, CODESET_PREFIX.length() - string.length()) + string;
    }

    private static CodeSetComponent getSelectedComponent(CodeSetComponentInfo codeSetComponentInfo, boolean bl) {
        return bl ? codeSetComponentInfo.ForWcharData : codeSetComponentInfo.ForCharData;
    }

    public CodeSet(int n, String string) {
        this.id = n;
        this.name = string;
    }

    public boolean supportsCharacterData(boolean bl) {
        return false;
    }

    public boolean supportsWideCharacterData() {
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean write_bom(boolean bl) {
        return false;
    }

    public char read_wchar(InputBuffer inputBuffer, int n, boolean bl) {
        throw new MARSHAL("Bad wide char codeSet: " + this.getName());
    }

    public String read_wstring(InputBuffer inputBuffer, int n, int n2, boolean bl) {
        throw new MARSHAL("Bad wide char codeSet: " + this.getName());
    }

    public void write_char(OutputBuffer outputBuffer, char c, boolean bl, boolean bl2, int n) {
        throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.getName());
    }

    public int get_wstring_size(String string, int n, int n2) {
        return 0;
    }

    protected final String readGiop12WString(InputBuffer inputBuffer, int n, int n2) {
        char[] cArray = new char[n];
        int n3 = inputBuffer.get_pos() + n;
        boolean bl = inputBuffer.readBOM();
        int n4 = 0;
        while (inputBuffer.get_pos() < n3) {
            cArray[n4++] = this.read_wchar(inputBuffer, n2, bl);
        }
        return new String(cArray, 0, n4);
    }

    public static void main(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && (stringArray[0].equals("-h") || !stringArray[0].equals("-a"))) {
            System.out.println("Usage: org.jacorb.orb.connection.CodeSet [-a]");
            System.exit(1);
        }
        Properties properties = System.getProperties();
        String string = (String)properties.get("os.name");
        System.out.println("Operating system name: " + string);
        System.out.println("Operating system version: " + properties.get("os.version"));
        System.out.println("Operating system architecture: " + properties.get("os.arch"));
        System.out.println("User region: " + System.getProperty("user.region"));
        System.out.println("JVM: " + properties.get("java.vm.version"));
        System.out.println("JacORB: 2.3.2 (JBoss patch 0), 23-Dec-2011");
        System.out.println("System file encoding property: " + System.getProperty("file.encoding"));
        String string2 = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        System.out.println("Cannonical encoding: " + string2);
        System.out.println("Default WChar encoding: " + nativeCodeSetWchar.getName());
        if (string.toLowerCase().indexOf("windows") == -1 && stringArray != null && stringArray.length == 1 && stringArray[0].equals("-a")) {
            String string3;
            BufferedReader bufferedReader;
            Process process;
            System.out.println("Locale is:");
            try {
                process = Runtime.getRuntime().exec("locale");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    System.out.println("    " + string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("Caught exception " + iOException);
            }
            System.out.println("All available locales are:");
            try {
                process = Runtime.getRuntime().exec("locale -a");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    System.out.println("        " + string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println("Caught exception " + iOException);
            }
        }
    }

    private static class Ucs2CodeSet
    extends TwoByteCodeSet {
        private Ucs2CodeSet() {
            super(65792, "UCS2");
        }

        public boolean write_bom(boolean bl) {
            return true;
        }
    }

    private static class Utf16CodeSet
    extends TwoByteCodeSet {
        private Utf16CodeSet() {
            super(65801, "UTF16");
        }

        public boolean write_bom(boolean bl) {
            return false;
        }
    }

    private static abstract class TwoByteCodeSet
    extends CodeSet {
        protected TwoByteCodeSet(int n, String string) {
            super(n, string);
        }

        public boolean supportsCharacterData(boolean bl) {
            return bl;
        }

        public char read_wchar(InputBuffer inputBuffer, int n, boolean bl) {
            if (bl) {
                return (char)(inputBuffer.readByte() & 0xFF | inputBuffer.readByte() << 8);
            }
            return (char)(inputBuffer.readByte() << 8 | inputBuffer.readByte() & 0xFF);
        }

        public String read_wstring(InputBuffer inputBuffer, int n, int n2, boolean bl) {
            if (n2 == 2) {
                return this.readGiop12WString(inputBuffer, n, n2);
            }
            char[] cArray = new char[n];
            int n3 = inputBuffer.get_pos() + 2 * n;
            int n4 = 0;
            while (inputBuffer.get_pos() < n3) {
                cArray[n4++] = this.read_wchar(inputBuffer, n2, bl);
            }
            if (n4 != 0 && cArray[n4 - 1] == '\u0000') {
                return new String(cArray, 0, n4 - 1);
            }
            return new String(cArray, 0, n4);
        }

        public void write_char(OutputBuffer outputBuffer, char c, boolean bl, boolean bl2, int n) {
            if (n < 2) {
                outputBuffer.write_short((short)c);
            } else {
                if (bl2) {
                    outputBuffer.write_byte((byte)2);
                }
                if (bl) {
                    outputBuffer.write_byte((byte)-2);
                    outputBuffer.write_byte((byte)-1);
                }
                outputBuffer.write_byte((byte)(c >> 8 & 0xFF));
                outputBuffer.write_byte((byte)(c & 0xFF));
            }
        }

        public int get_wstring_size(String string, int n, int n2) {
            return string.length() + 1;
        }
    }

    private static class Utf8CodeSet
    extends CodeSet {
        private Utf8CodeSet() {
            super(0x5010001, "UTF8");
        }

        public boolean supportsCharacterData(boolean bl) {
            return true;
        }

        public char read_wchar(InputBuffer inputBuffer, int n, boolean bl) {
            if (n < 2) {
                throw new MARSHAL("GIOP 1." + n + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
            }
            short s = (short)(0xFF & inputBuffer.readByte());
            if ((s & 0x80) == 0) {
                return (char)s;
            }
            if ((s & 0xE0) == 192) {
                return (char)((s & 0x1F) << 6 | inputBuffer.readByte() & 0x3F);
            }
            short s2 = (short)(0xFF & inputBuffer.readByte());
            return (char)((s & 0xF) << 12 | (s2 & 0x3F) << 6 | inputBuffer.readByte() & 0x3F);
        }

        public String read_wstring(InputBuffer inputBuffer, int n, int n2, boolean bl) {
            if (n2 < 2) {
                throw new MARSHAL("Bad wide char codeSet: " + this.getName());
            }
            return this.readGiop12WString(inputBuffer, n, n2);
        }

        public void write_char(OutputBuffer outputBuffer, char c, boolean bl, boolean bl2, int n) {
            if (c <= '\u007f') {
                if (n == 2 && bl2) {
                    outputBuffer.write_byte((byte)1);
                }
                outputBuffer.write_byte((byte)c);
            } else if (c > '\u07ff') {
                if (n == 2 && bl2) {
                    outputBuffer.write_byte((byte)3);
                }
                outputBuffer.write_byte((byte)(0xE0 | c >> 12 & 0xF));
                outputBuffer.write_byte((byte)(0x80 | c >> 6 & 0x3F));
                outputBuffer.write_byte((byte)(0x80 | c >> 0 & 0x3F));
            } else {
                if (n == 2 && bl2) {
                    outputBuffer.write_byte((byte)2);
                }
                outputBuffer.write_byte((byte)(0xC0 | c >> 6 & 0x1F));
                outputBuffer.write_byte((byte)(0x80 | c >> 0 & 0x3F));
            }
        }

        public int get_wstring_size(String string, int n, int n2) {
            return n2 - n - 4;
        }
    }

    private static class Iso8859_1CodeSet
    extends CodeSet {
        private Iso8859_1CodeSet() {
            super(65537, "ISO8859_1");
        }

        public boolean supportsCharacterData(boolean bl) {
            return !bl;
        }

        public void write_char(OutputBuffer outputBuffer, char c, boolean bl, boolean bl2, int n) {
            outputBuffer.write_byte((byte)c);
        }
    }

    public static interface OutputBuffer {
        public void write_byte(byte var1);

        public void write_short(short var1);
    }

    public static interface InputBuffer {
        public byte readByte();

        public int get_pos();

        public boolean readBOM();
    }
}

