/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);
    private Schema schema;
    private Message message;

    public Object read(MessagePartInfo part, XMLStreamReader input) {
        return this.read(null, input, part.getTypeClass());
    }

    public Object read(final QName name, XMLStreamReader input, Class type) {
        if (Source.class.equals((Object)type) && this.message != null) {
            String s = (String)this.message.getContextualProperty("source-preferred-format");
            if (StringUtils.isEmpty((String)s)) {
                s = "sax";
            }
            if ("dom".equalsIgnoreCase(s)) {
                type = DOMSource.class;
            } else if ("stream".equalsIgnoreCase(s)) {
                type = StreamSource.class;
            } else if ("sax".equalsIgnoreCase(s) || "cxf.stax".equalsIgnoreCase(s)) {
                type = SAXSource.class;
            } else if ("stax".equals(s)) {
                try {
                    type = ClassLoaderUtils.loadClass((String)"javax.xml.transform.stax.StAXSource", this.getClass());
                }
                catch (ClassNotFoundException e) {
                    type = SAXSource.class;
                }
            } else {
                type = DOMSource.class;
            }
        }
        try {
            Element dom = null;
            if (this.schema != null) {
                dom = this.validate(input);
                input = StaxUtils.createXMLStreamReader((Element)dom);
            }
            if (type != null) {
                Object o;
                Object retVal = null;
                if (SAXSource.class.isAssignableFrom(type) || StaxSource.class.isAssignableFrom(type)) {
                    retVal = new StaxSource(this.resetForStreaming(input));
                } else if (StreamSource.class.isAssignableFrom(type)) {
                    retVal = new StreamSource(this.getInputStream(input));
                } else if (XMLStreamReader.class.isAssignableFrom(type)) {
                    retVal = this.resetForStreaming(input);
                } else if (Element.class.isAssignableFrom(type)) {
                    retVal = dom == null ? this.read(input).getNode() : dom;
                } else if (Document.class.isAssignableFrom(type)) {
                    retVal = dom == null ? this.read(input).getNode() : dom;
                } else if (DataSource.class.isAssignableFrom(type)) {
                    final InputStream ins = this.getInputStream(input);
                    retVal = new DataSource(){

                        public String getContentType() {
                            return "text/xml";
                        }

                        public InputStream getInputStream() throws IOException {
                            return ins;
                        }

                        public String getName() {
                            return name.toString();
                        }

                        public OutputStream getOutputStream() throws IOException {
                            return null;
                        }
                    };
                } else if ("javax.xml.transform.stax.StAXSource".equals(type.getName()) && (o = this.createStaxSource(input = this.resetForStreaming(input), type)) != null) {
                    retVal = o;
                }
                if (retVal != null) {
                    return retVal;
                }
            }
            return dom == null ? this.read(input) : new DOMSource(dom);
        }
        catch (IOException e) {
            throw new Fault("COULD_NOT_READ_XML_STREAM", LOG, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new Fault("COULD_NOT_READ_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
        }
        catch (SAXException e) {
            throw new Fault("COULD_NOT_READ_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
        }
    }

    private Object createStaxSource(XMLStreamReader input, Class<?> type) {
        try {
            return type.getConstructor(XMLStreamReader.class).newInstance(input);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private XMLStreamReader resetForStreaming(XMLStreamReader input) throws XMLStreamException {
        if (this.message != null) {
            this.message.removeContent(XMLStreamReader.class);
            final InputStream ins = (InputStream)this.message.getContent(InputStream.class);
            this.message.removeContent(InputStream.class);
            input = new FragmentStreamReader(input, true){
                boolean closed;

                public boolean hasNext() throws XMLStreamException {
                    boolean b = super.hasNext();
                    if (!b && !this.closed) {
                        this.closed = true;
                        try {
                            super.close();
                        }
                        catch (XMLStreamException e) {
                            // empty catch block
                        }
                        try {
                            ins.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return b;
                }

                public void close() throws XMLStreamException {
                    try {
                        super.close();
                    }
                    catch (XMLStreamException e) {
                        // empty catch block
                    }
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        return input;
    }

    private Element validate(XMLStreamReader input) throws XMLStreamException, SAXException, IOException {
        DOMSource ds = this.read(input);
        this.schema.newValidator().validate(ds);
        Node nd = ds.getNode();
        if (nd instanceof Document) {
            return ((Document)nd).getDocumentElement();
        }
        return (Element)ds.getNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(XMLStreamReader input) throws XMLStreamException, IOException {
        CachedOutputStream out = new CachedOutputStream();
        try {
            StaxUtils.copy((XMLStreamReader)input, (OutputStream)out);
            InputStream inputStream = out.getInputStream();
            return inputStream;
        }
        finally {
            out.close();
        }
    }

    public DOMSource read(XMLStreamReader reader) {
        try {
            XMLStreamReader reader2 = reader;
            if (reader2 instanceof DepthXMLStreamReader) {
                reader2 = ((DepthXMLStreamReader)reader2).getReader();
            }
            if (reader2 instanceof W3CDOMStreamReader) {
                W3CDOMStreamReader domreader = (W3CDOMStreamReader)reader2;
                DOMSource o = new DOMSource(domreader.getCurrentElement());
                domreader.consumeFrame();
                return o;
            }
            Document document = StaxUtils.read((XMLStreamReader)reader);
            if (reader.hasNext()) {
                reader.next();
            }
            return new DOMSource(document);
        }
        catch (XMLStreamException e) {
            throw new Fault("COULD_NOT_READ_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
        }
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String prop, Object value) {
        if (Message.class.getName().equals(prop)) {
            this.message = (Message)value;
        }
    }
}

