/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.extension.BusExtension;

@NoJSR250Annotations
public class ServerLifeCycleManagerImpl
implements ServerLifeCycleManager,
BusExtension {
    private CopyOnWriteArrayList<ServerLifeCycleListener> listeners = new CopyOnWriteArrayList();

    public ServerLifeCycleManagerImpl() {
    }

    public ServerLifeCycleManagerImpl(Bus b) {
        Collection l = ((ConfiguredBeanLocator)b.getExtension(ConfiguredBeanLocator.class)).getBeansOfType(ServerLifeCycleListener.class);
        if (l != null) {
            this.listeners.addAll(l);
        }
    }

    public Class<?> getRegistrationType() {
        return ServerLifeCycleManager.class;
    }

    public synchronized void registerListener(ServerLifeCycleListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void startServer(Server server) {
        for (ServerLifeCycleListener listener : this.listeners) {
            listener.startServer(server);
        }
    }

    public void stopServer(Server server) {
        for (ServerLifeCycleListener listener : this.listeners) {
            listener.stopServer(server);
        }
    }

    public synchronized void unRegisterListener(ServerLifeCycleListener listener) {
        this.listeners.remove(listener);
    }
}

