/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxOutEndingInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class FIStaxOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String FI_ENABLED = "org.apache.cxf.fastinfoset.enabled";
    private static final String OUTPUT_STREAM_HOLDER = FIStaxOutInterceptor.class.getName() + ".outputstream";
    private static final StaxOutEndingInterceptor ENDING = new StaxOutEndingInterceptor(OUTPUT_STREAM_HOLDER);
    boolean force;

    public FIStaxOutInterceptor() {
        super("pre-stream");
        this.addAfter(AttachmentOutInterceptor.class.getName());
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public FIStaxOutInterceptor(boolean f) {
        this();
        this.force = f;
    }

    public void handleFault(Message message) {
        super.handleFault(message);
        OutputStream os = (OutputStream)message.get((Object)OUTPUT_STREAM_HOLDER);
        if (os != null) {
            message.setContent(OutputStream.class, (Object)os);
        }
    }

    public void handleMessage(Message message) {
        OutputStream out = (OutputStream)message.getContent(OutputStream.class);
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        if (out == null || writer != null) {
            return;
        }
        boolean req = this.isRequestor(message);
        Object o = message.getContextualProperty(FI_ENABLED);
        if (!req) {
            String s;
            if (message.getExchange().getInMessage() != null && (s = (String)message.getExchange().getInMessage().get((Object)"Accept")) != null && s.contains("fastinfoset")) {
                o = Boolean.TRUE;
            }
        } else {
            Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
            ArrayList<String> accepts = (ArrayList<String>)headers.get("Accept");
            if (accepts == null) {
                accepts = new ArrayList<String>();
                headers.put("Accept", accepts);
            }
            String a = "application/fastinfoset";
            if (!accepts.isEmpty()) {
                a = a + ", " + (String)accepts.get(0);
                accepts.set(0, a);
            } else {
                accepts.add(a);
            }
        }
        if (this.force || MessageUtils.isTrue((Object)o)) {
            StAXDocumentSerializer serializer = this.getOutput(message, out);
            message.setContent(XMLStreamWriter.class, (Object)serializer);
            message.removeContent(OutputStream.class);
            message.put((Object)OUTPUT_STREAM_HOLDER, (Object)out);
            message.put((Object)"disable.outputstream.optimization", (Object)Boolean.TRUE);
            String s = (String)message.get((Object)"Content-Type");
            if (s.contains("application/soap+xml")) {
                s = s.replace("application/soap+xml", "application/soap+fastinfoset");
                message.put((Object)"Content-Type", (Object)s);
            } else {
                message.put((Object)"Content-Type", (Object)"application/fastinfoset");
            }
            try {
                serializer.writeStartDocument();
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
            message.getInterceptorChain().add((Interceptor)ENDING);
        }
    }

    private StAXDocumentSerializer getOutput(Message m, OutputStream out) {
        return new StAXDocumentSerializer(out);
    }
}

