/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.export;

import java.io.IOException;
import junit.framework.TestCase;
import org.gatein.exports.data.ExportData;
import org.gatein.exports.data.ExportPortletData;
import org.gatein.wsrp.test.ExtendedAssert;

public class ExportTestCase
extends TestCase {
    public void testTransformationByValueStateless() throws IOException {
        String portletId = "TestPortletID_123";
        double version = 1.0;
        ExportPortletData exportPortletData = new ExportPortletData(portletId, null);
        ExportTestCase.assertEquals((Object)version, (Object)exportPortletData.getVersion());
        ExportTestCase.assertEquals((String)portletId, (String)exportPortletData.getPortletHandle());
        ExportTestCase.assertNull((Object)exportPortletData.getPortletState());
        byte[] bytes = exportPortletData.encodeAsBytes();
        byte[] internalBytes = ExportData.getInternalBytes((byte[])bytes);
        ExportPortletData portletDataFromBytes = ExportPortletData.create((byte[])internalBytes);
        ExportTestCase.assertEquals((Object)version, (Object)portletDataFromBytes.getVersion());
        ExportTestCase.assertEquals((String)portletId, (String)portletDataFromBytes.getPortletHandle());
        ExportTestCase.assertEquals((Object)version, (Object)portletDataFromBytes.getVersion());
        ExportTestCase.assertNull((Object)portletDataFromBytes.getPortletState());
    }

    public void testTransformationByValueStatefull() throws IOException {
        String portletId = "TestPortletID_123";
        double version = 1.0;
        byte[] state = new byte[]{-66, 0, 1, 2, 3, 97, 98, 99};
        ExportPortletData exportPortletData = new ExportPortletData(portletId, state);
        ExportTestCase.assertEquals((Object)version, (Object)exportPortletData.getVersion());
        ExportTestCase.assertEquals((String)portletId, (String)exportPortletData.getPortletHandle());
        ExportTestCase.assertNotNull((Object)exportPortletData.getPortletState());
        ExtendedAssert.assertEquals((byte[])state, (byte[])exportPortletData.getPortletState());
        byte[] bytes = exportPortletData.encodeAsBytes();
        byte[] internalBytes = ExportData.getInternalBytes((byte[])bytes);
        ExportPortletData portletDataFromBytes = ExportPortletData.create((byte[])internalBytes);
        ExportTestCase.assertEquals((Object)version, (Object)portletDataFromBytes.getVersion());
        ExportTestCase.assertEquals((String)portletId, (String)portletDataFromBytes.getPortletHandle());
        ExportTestCase.assertEquals((Object)version, (Object)portletDataFromBytes.getVersion());
        ExportTestCase.assertNotNull((Object)portletDataFromBytes.getPortletState());
        ExportTestCase.assertEquals((int)state.length, (int)portletDataFromBytes.getPortletState().length);
        ExtendedAssert.assertEquals((byte[])state, (byte[])portletDataFromBytes.getPortletState());
    }
}

