/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.common.util.MapBuilder;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.RegistrationSPI;

public abstract class AbstractRegistrationPersistenceManagerTestCase
extends TestCase {
    private Map<QName, Object> registrationProperties;

    public abstract RegistrationPersistenceManager getManager() throws Exception;

    public void setUp() throws Exception {
        this.registrationProperties = new HashMap<QName, Object>();
        this.registrationProperties.put(new QName("prop1"), "value1");
        this.registrationProperties.put(new QName("prop2"), "value2");
    }

    protected void tearDown() throws Exception {
        this.registrationProperties = null;
    }

    public void testGetGroupThrowsIAE() throws Exception {
        try {
            this.getManager().getConsumerGroup(null);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateConsumer() throws Exception {
        Consumer consumer = this.getManager().createConsumer("BarId", "BarName");
        AbstractRegistrationPersistenceManagerTestCase.assertTrue((boolean)this.getManager().isConsumerExisting("BarId"));
        AbstractRegistrationPersistenceManagerTestCase.assertFalse((boolean)this.getManager().isConsumerExisting("BarName"));
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)consumer);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"BarName", (String)consumer.getName());
        AbstractRegistrationPersistenceManagerTestCase.assertTrue((boolean)consumer.getRegistrations().isEmpty());
        AbstractRegistrationPersistenceManagerTestCase.assertNull((Object)consumer.getGroup());
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)consumer.getPersistentKey());
        AbstractRegistrationPersistenceManagerTestCase.assertNull((Object)consumer.getConsumerAgent());
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)consumer.getCapabilities());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)consumer.getStatus());
    }

    public void testCreateConsumerThrowsIAE() throws Exception {
        try {
            this.getManager().createConsumer(null, "foo");
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.getManager().createConsumer("foo", null);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateDuplicatedConsumer() throws Exception {
        this.getManager().createConsumer("id", "name");
        AbstractRegistrationPersistenceManagerTestCase.assertTrue((boolean)this.getManager().isConsumerExisting("id"));
        AbstractRegistrationPersistenceManagerTestCase.assertFalse((boolean)this.getManager().isConsumerExisting("name"));
        try {
            this.getManager().createConsumer("id", "different name");
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (DuplicateRegistrationException duplicateRegistrationException) {
            // empty catch block
        }
        this.getManager().createConsumer("different id", "name");
        AbstractRegistrationPersistenceManagerTestCase.assertTrue((boolean)this.getManager().isConsumerExisting("different id"));
    }

    public void testCreateGroup() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)group);
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)group.getPersistentKey());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Foo", (String)group.getName());
        AbstractRegistrationPersistenceManagerTestCase.assertTrue((boolean)group.getConsumers().isEmpty());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)group.getStatus());
    }

    public void testCreateGroupThrowsIAE() throws Exception {
        try {
            this.getManager().createConsumerGroup(null);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddGroup() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)group);
        group = this.getManager().getConsumerGroup("Foo");
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)group);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Foo", (String)group.getName());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_LIST, new ArrayList(group.getConsumers()));
        Collection groups = this.getManager().getConsumerGroups();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)groups);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((int)1, (int)groups.size());
        group = (ConsumerGroup)groups.iterator().next();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)group);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Foo", (String)group.getName());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_LIST, new ArrayList(group.getConsumers()));
    }

    public void testAddDuplicateGroup() throws Exception {
        this.getManager().createConsumerGroup("Foo");
        try {
            this.getManager().createConsumerGroup("Foo");
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (DuplicateRegistrationException duplicateRegistrationException) {
            // empty catch block
        }
    }

    public void testAddGroupThrowsIAE() throws Exception {
        try {
            this.getManager().createConsumerGroup(null);
        }
        catch (IllegalArgumentException expected) {
            AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_SET, new HashSet(this.getManager().getConsumerGroups()));
        }
    }

    public void testRemoveGroup() throws Exception {
        this.getManager().createConsumerGroup("Foo");
        this.getManager().removeConsumerGroup("Foo");
        AbstractRegistrationPersistenceManagerTestCase.assertNull((Object)this.getManager().getConsumerGroup("Foo"));
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_SET, new HashSet(this.getManager().getConsumerGroups()));
    }

    public void testRemoveGroupThrowsIAE() throws Exception {
        try {
            this.getManager().removeConsumerGroup(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveNonExistingGroup() throws Exception {
        try {
            this.getManager().removeConsumerGroup("Foo");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
    }

    public void testGetConsumerThrowsIAE() throws Exception {
        try {
            ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
            group.getConsumer(null);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddConsumer() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Foo", (String)consumer.getGroup().getName());
        consumer = group.getConsumer("Bar");
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)consumer);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Bar", (String)consumer.getName());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_LIST, new ArrayList(consumer.getRegistrations()));
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Foo", (String)consumer.getGroup().getName());
        Collection consumers = group.getConsumers();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)consumers);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((int)1, (int)consumers.size());
        consumer = (Consumer)consumers.iterator().next();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)consumer);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Bar", (String)consumer.getName());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_LIST, new ArrayList(consumer.getRegistrations()));
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)"Foo", (String)consumer.getGroup().getName());
    }

    public void testAddDuplicateConsumer() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        try {
            group.addConsumer(consumer);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddConsumerThrowsIAE() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        try {
            group.addConsumer(null);
        }
        catch (IllegalArgumentException expected) {
            AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_SET, new HashSet(group.getConsumers()));
        }
    }

    public void testRemoveConsumer() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        group.removeConsumer(consumer);
        AbstractRegistrationPersistenceManagerTestCase.assertNull((Object)group.getConsumer("Bar"));
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)Collections.EMPTY_SET, new HashSet(group.getConsumers()));
    }

    public void testRemoveConsumerThrowsIAE() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        try {
            group.removeConsumer(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddRegistration() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        consumer = this.getManager().getConsumerById("Bar");
        RegistrationSPI reg1 = this.getManager().addRegistrationFor("Bar", this.registrationProperties);
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)reg1);
        String regId = reg1.getPersistentKey();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)regId);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)consumer, (Object)reg1.getConsumer());
        consumer = this.getManager().getConsumerById("Bar");
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)reg1, (Object)consumer.getRegistration(regId));
        HashMap<QName, String> expectedProps = new HashMap<QName, String>();
        expectedProps.put(new QName("prop1"), "value1");
        expectedProps.put(new QName("prop2"), "value2");
        AbstractRegistrationPersistenceManagerTestCase.assertEquals(expectedProps, (Object)reg1.getProperties());
        consumer = this.getManager().getConsumerById("Bar");
        Collection registrations = consumer.getRegistrations();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)registrations);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((int)1, (int)registrations.size());
        Registration reg3 = (Registration)registrations.iterator().next();
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)reg1, (Object)reg3);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)regId, (String)reg3.getPersistentKey());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)consumer, (Object)reg3.getConsumer());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals(expectedProps, (Object)reg3.getProperties());
        Registration reg2 = this.getManager().getRegistration(regId);
        consumer = this.getManager().getConsumerById("Bar");
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)reg2);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((String)regId, (String)reg2.getPersistentKey());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)consumer, (Object)reg2.getConsumer());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals(expectedProps, (Object)reg2.getProperties());
    }

    public void testAddRegistrationThrowsIAE() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        try {
            this.getManager().addRegistrationFor(consumer.getId(), null);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveRegistrationThrowsIAE() throws Exception {
        try {
            this.getManager().removeRegistration(null);
            AbstractRegistrationPersistenceManagerTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveRegistration() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        RegistrationSPI reg = this.getManager().addRegistrationFor("Bar", this.registrationProperties);
        String regId = reg.getPersistentKey();
        this.getManager().removeRegistration(regId);
        consumer = this.getManager().getConsumerById("Bar");
        Collection registrations = consumer.getRegistrations();
        AbstractRegistrationPersistenceManagerTestCase.assertNotNull((Object)registrations);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((int)0, (int)registrations.size());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals(null, (Object)this.getManager().getRegistration(regId));
    }

    public void testBulkUpdateRegistrationProperties() throws Exception {
        ConsumerGroup group = this.getManager().createConsumerGroup("Foo");
        Consumer consumer = this.getManager().createConsumer("Bar", "Bar");
        group.addConsumer(consumer);
        this.getManager().addRegistrationFor("Bar", this.registrationProperties);
        consumer = this.getManager().getConsumerById("Bar");
        Registration reg = (Registration)consumer.getRegistrations().iterator().next();
        this.registrationProperties.remove(new QName("prop1"));
        reg.updateProperties(this.registrationProperties);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals(Collections.singletonMap(new QName("prop2"), "value2"), (Object)reg.getProperties());
        this.getManager().saveChangesTo(reg);
        Registration registration = this.getManager().getRegistration(reg.getPersistentKey());
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)reg.getProperties(), (Object)registration.getProperties());
        consumer = this.getManager().getConsumerById("Bar");
        reg = (Registration)consumer.getRegistrations().iterator().next();
        AbstractRegistrationPersistenceManagerTestCase.assertEquals(Collections.singletonMap(new QName("prop2"), "value2"), (Object)reg.getProperties());
        this.registrationProperties.put(new QName("prop3"), "value3");
        reg.updateProperties(this.registrationProperties);
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)MapBuilder.hashMap().put((Object)new QName("prop2"), (Object)"value2").put((Object)new QName("prop3"), (Object)"value3").get(), (Object)reg.getProperties());
        this.getManager().saveChangesTo(reg);
        consumer = this.getManager().getConsumerById("Bar");
        reg = (Registration)consumer.getRegistrations().iterator().next();
        AbstractRegistrationPersistenceManagerTestCase.assertEquals((Object)MapBuilder.hashMap().put((Object)new QName("prop2"), (Object)"value2").put((Object)new QName("prop3"), (Object)"value3").get(), (Object)reg.getProperties());
    }
}

