/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import junit.framework.TestCase;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.impl.RegistrationManagerImpl;
import org.gatein.registration.impl.RegistrationPersistenceManagerImpl;
import org.gatein.registration.policies.DefaultRegistrationPolicy;

public class ConsumerGroupTestCase
extends TestCase {
    private RegistrationManager manager;
    private ConsumerGroup group;
    private static final String NAME = "name";

    protected void setUp() throws Exception {
        this.manager = new RegistrationManagerImpl();
        DefaultRegistrationPolicy policy = new DefaultRegistrationPolicy();
        this.manager.setPolicy((RegistrationPolicy)policy);
        this.manager.setPersistenceManager((RegistrationPersistenceManager)new RegistrationPersistenceManagerImpl());
        this.group = this.manager.createConsumerGroup(NAME);
    }

    public void testGetName() {
        ConsumerGroupTestCase.assertEquals((String)NAME, (String)this.group.getName());
    }

    public void testConsumersManagement() throws RegistrationException {
        ConsumerGroupTestCase.assertTrue((boolean)this.group.isEmpty());
        ConsumerGroupTestCase.assertEquals((int)0, (int)this.group.getConsumers().size());
        Consumer c1 = this.manager.createConsumer("c1");
        this.group.addConsumer(c1);
        ConsumerGroupTestCase.assertTrue((!this.group.isEmpty() ? 1 : 0) != 0);
        ConsumerGroupTestCase.assertEquals((int)1, (int)this.group.getConsumers().size());
        ConsumerGroupTestCase.assertTrue((boolean)this.group.contains(c1));
        ConsumerGroupTestCase.assertEquals((Object)this.group, (Object)c1.getGroup());
        ConsumerGroupTestCase.assertEquals((Object)c1, (Object)this.group.getConsumer(c1.getId()));
        Consumer c2 = this.manager.createConsumer("c2");
        this.group.addConsumer(c2);
        ConsumerGroupTestCase.assertEquals((int)2, (int)this.group.getConsumers().size());
        ConsumerGroupTestCase.assertTrue((boolean)this.group.contains(c2));
        ConsumerGroupTestCase.assertEquals((Object)this.group, (Object)c2.getGroup());
        this.group.removeConsumer(c1);
        ConsumerGroupTestCase.assertEquals((int)1, (int)this.group.getConsumers().size());
        ConsumerGroupTestCase.assertTrue((!this.group.contains(c1) ? 1 : 0) != 0);
        ConsumerGroupTestCase.assertTrue((boolean)this.group.contains(c2));
        ConsumerGroupTestCase.assertEquals(null, (Object)c1.getGroup());
    }

    public void testAddNullConsumer() throws RegistrationException {
        try {
            this.group.addConsumer(null);
            ConsumerGroupTestCase.fail((String)"Shouldn't be possible to add null consumer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStatus() {
        ConsumerGroupTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)this.group.getStatus());
        this.group.setStatus(RegistrationStatus.VALID);
        ConsumerGroupTestCase.assertEquals((Object)RegistrationStatus.VALID, (Object)this.group.getStatus());
    }

    public void testIllegalStatus() {
        try {
            this.group.setStatus(null);
            ConsumerGroupTestCase.fail((String)"Shouldn't be possible to set the status to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

