/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.impl.RegistrationManagerImpl;
import org.gatein.registration.impl.RegistrationPersistenceManagerImpl;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

public class ConsumerTestCase
extends TestCase {
    private Consumer consumer;
    private RegistrationManager manager;
    private static final Map<QName, RegistrationPropertyDescription> EMPTY_EXPECTATIONS = Collections.emptyMap();

    protected void setUp() throws Exception {
        this.manager = new RegistrationManagerImpl();
        DefaultRegistrationPolicy policy = new DefaultRegistrationPolicy();
        policy.setValidator((RegistrationPropertyValidator)new DefaultRegistrationPropertyValidator());
        this.manager.setPolicy((RegistrationPolicy)policy);
        this.manager.setPersistenceManager((RegistrationPersistenceManager)new RegistrationPersistenceManagerImpl());
        this.consumer = this.manager.createConsumer("name");
    }

    public void testGetName() {
        ConsumerTestCase.assertEquals((String)"name", (String)this.consumer.getName());
    }

    public void testStatus() throws RegistrationException {
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)this.consumer.getStatus());
        String name = this.consumer.getName();
        Registration registration = this.manager.addRegistrationTo(name, Collections.emptyMap(), EMPTY_EXPECTATIONS, false);
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)this.consumer.getStatus());
        registration.setStatus(RegistrationStatus.VALID);
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.VALID, (Object)this.consumer.getStatus());
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        QName propName = new QName("prop");
        props.put(propName, "value");
        HashMap<QName, RegistrationPropertyDescription> expectations = new HashMap<QName, RegistrationPropertyDescription>();
        expectations.put(propName, new RegistrationPropertyDescription(propName, WSRPConstants.XSD_STRING));
        registration = this.manager.addRegistrationTo(name, props, expectations, false);
        ConsumerTestCase.assertEquals((int)2, (int)this.consumer.getRegistrations().size());
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)this.consumer.getStatus());
        registration.setStatus(RegistrationStatus.INVALID);
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.INVALID, (Object)this.consumer.getStatus());
        registration.setStatus(RegistrationStatus.PENDING);
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)this.consumer.getStatus());
        registration.setStatus(RegistrationStatus.VALID);
        ConsumerTestCase.assertEquals((Object)RegistrationStatus.VALID, (Object)this.consumer.getStatus());
    }

    public void testSetGroup() throws Exception {
        ConsumerGroup group = this.manager.createConsumerGroup("group");
        ConsumerTestCase.assertTrue((!group.getConsumers().contains(this.consumer) ? 1 : 0) != 0);
        this.consumer.setGroup(group);
        ConsumerTestCase.assertEquals((Object)group, (Object)this.consumer.getGroup());
        ConsumerTestCase.assertTrue((boolean)group.getConsumers().contains(this.consumer));
        this.consumer.setGroup(null);
        ConsumerTestCase.assertNull((Object)this.consumer.getGroup());
        ConsumerTestCase.assertTrue((!group.getConsumers().contains(this.consumer) ? 1 : 0) != 0);
    }

    public void testGetIdentity() throws Exception {
        ConsumerTestCase.assertNotNull((Object)this.consumer.getId());
    }
}

