/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.impl.RegistrationManagerImpl;
import org.gatein.registration.impl.RegistrationPersistenceManagerImpl;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

public class RegistrationManagerTestCase
extends TestCase {
    private RegistrationManager manager;
    private Map<QName, Object> registrationProperties;
    private Map<QName, RegistrationPropertyDescription> expectations;

    protected void setUp() throws Exception {
        this.manager = new RegistrationManagerImpl();
        DefaultRegistrationPolicy policy = new DefaultRegistrationPolicy();
        policy.setValidator((RegistrationPropertyValidator)new DefaultRegistrationPropertyValidator());
        this.manager.setPolicy((RegistrationPolicy)policy);
        this.manager.setPersistenceManager((RegistrationPersistenceManager)new RegistrationPersistenceManagerImpl());
        QName prop1Name = new QName("prop1");
        QName prop2Name = new QName("prop2");
        this.registrationProperties = new HashMap<QName, Object>();
        this.registrationProperties.put(prop1Name, "value1");
        this.registrationProperties.put(prop2Name, "value2");
        this.expectations = new HashMap<QName, RegistrationPropertyDescription>();
        this.expectations.put(prop1Name, new RegistrationPropertyDescription(prop1Name, WSRPConstants.XSD_STRING));
        this.expectations.put(prop2Name, new RegistrationPropertyDescription(prop2Name, WSRPConstants.XSD_STRING));
    }

    public void testPolicy() {
        RegistrationPolicy policy = this.manager.getPolicy();
        RegistrationManagerTestCase.assertNotNull((Object)policy);
    }

    public void testAddRegistrationTo() throws Exception {
        Registration registration = this.manager.addRegistrationTo("consumerName", this.registrationProperties, this.expectations, true);
        RegistrationManagerTestCase.assertNotNull((Object)registration);
        RegistrationManagerTestCase.assertNotNull((Object)registration.getPersistentKey());
        Consumer consumer = this.manager.getConsumerByIdentity("consumerName");
        RegistrationManagerTestCase.assertNotNull((Object)consumer);
        RegistrationManagerTestCase.assertEquals((Object)consumer, (Object)registration.getConsumer());
        String registrationHandle = registration.getRegistrationHandle();
        RegistrationManagerTestCase.assertNotNull((Object)registrationHandle);
        RegistrationManagerTestCase.assertEquals((Object)consumer, (Object)this.manager.getConsumerFor(registrationHandle));
    }

    public void testAddRegistrationToInexistentConsumer() throws RegistrationException {
        try {
            this.manager.addRegistrationTo("consumerName", this.registrationProperties, this.expectations, false);
            RegistrationManagerTestCase.fail((String)"Should have failed: consumer does not exist");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity("consumerName"));
    }

    public void testGetConsumerForNullRegistrationHandle() throws Exception {
        try {
            this.manager.getConsumerFor(null);
            RegistrationManagerTestCase.fail((String)"Should have failed: cannot find a consumer for a null registration handle");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateConsumer() throws Exception {
        String name = "consumerName";
        Consumer consumer = this.manager.createConsumer(name);
        RegistrationManagerTestCase.assertNotNull((Object)consumer);
        RegistrationManagerTestCase.assertEquals((String)name, (String)consumer.getName());
        RegistrationManagerTestCase.assertNotNull((Object)consumer.getId());
        RegistrationManagerTestCase.assertNull((Object)consumer.getGroup());
        Collection consumers = this.manager.getConsumers();
        RegistrationManagerTestCase.assertEquals((int)1, (int)consumers.size());
        RegistrationManagerTestCase.assertTrue((boolean)consumers.contains(consumer));
        RegistrationManagerTestCase.assertEquals((Object)consumer, (Object)this.manager.getConsumerByIdentity(name));
        try {
            consumers.add(consumer);
            RegistrationManagerTestCase.fail((String)"Shouldn't be possible to directly modify consumer collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
    }

    public void testCreateConsumerWithGroupFromPolicy() throws RegistrationException {
        DefaultRegistrationPolicy policy = new DefaultRegistrationPolicy(){

            public String getAutomaticGroupNameFor(String consumerName) {
                return "group_" + consumerName;
            }
        };
        this.manager.setPolicy((RegistrationPolicy)policy);
        String name = "name";
        Consumer consumer = this.manager.createConsumer(name);
        RegistrationManagerTestCase.assertNotNull((Object)consumer);
        ConsumerGroup group = this.manager.getConsumerGroup("group_" + name);
        RegistrationManagerTestCase.assertNotNull((Object)group);
        RegistrationManagerTestCase.assertEquals((Object)group, (Object)consumer.getGroup());
        RegistrationManagerTestCase.assertTrue((boolean)group.getConsumers().contains(consumer));
    }

    public void testCreateDuplicateConsumer() throws RegistrationException {
        String name = "name";
        RegistrationManagerTestCase.assertNotNull((Object)this.manager.createConsumer(name));
        try {
            this.manager.createConsumer(name);
            RegistrationManagerTestCase.fail((String)"Should have failed when trying to create a consumer with an existing name");
        }
        catch (DuplicateRegistrationException duplicateRegistrationException) {
            // empty catch block
        }
    }

    public void testAddAutomaticallyCreatedConsumerToInexistentGroup() throws RegistrationException {
        try {
            this.manager.addConsumerToGroupNamed("foo", "bar", false, true);
            RegistrationManagerTestCase.fail((String)"Shouldn't be possible to add a consumer to an inexistent group without first creating it");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity("foo"));
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerGroup("bar"));
    }

    public void testAddInexistentConsumerToAutomaticallyCreatedGroup() throws RegistrationException {
        try {
            this.manager.addConsumerToGroupNamed("foo", "bar", true, false);
            RegistrationManagerTestCase.fail((String)"Shouldn't be possible to add an inexistent consumer to a group without first creating it");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity("foo"));
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerGroup("bar"));
    }

    public void testAddInexistentConsumerToGroup() throws RegistrationException {
        this.manager.createConsumerGroup("bar");
        try {
            this.manager.addConsumerToGroupNamed("foo", "bar", false, false);
            RegistrationManagerTestCase.fail((String)"Shouldn't be possible to add an inexistent consumer to a group without first creating it");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity("foo"));
        RegistrationManagerTestCase.assertNotNull((Object)this.manager.getConsumerGroup("bar"));
    }

    public void testAddInexistentConsumerToInexistentGroup() throws RegistrationException {
        try {
            this.manager.addConsumerToGroupNamed("foo", "bar", false, false);
            RegistrationManagerTestCase.fail((String)"Shouldn't be possible to add a consumer to an inexistent group without first creating it");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity("foo"));
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerGroup("bar"));
    }

    public void testAddConsumerToGroup() throws Exception {
        String groupName = "group";
        String consumerName = "consumer";
        Consumer consumer = this.manager.addConsumerToGroupNamed(consumerName, groupName, true, true);
        Consumer consumer1 = this.manager.getConsumerByIdentity(consumerName);
        RegistrationManagerTestCase.assertNotNull((Object)consumer1);
        RegistrationManagerTestCase.assertEquals((Object)consumer1, (Object)consumer);
        ConsumerGroup group = this.manager.getConsumerGroup(groupName);
        RegistrationManagerTestCase.assertNotNull((Object)group);
        RegistrationManagerTestCase.assertEquals((Object)group, (Object)consumer.getGroup());
    }

    public void testCreateConsumerGroup() throws Exception {
        String groupName = "name";
        ConsumerGroup group = this.manager.createConsumerGroup(groupName);
        RegistrationManagerTestCase.assertNotNull((Object)group);
        RegistrationManagerTestCase.assertEquals((String)groupName, (String)group.getName());
        Collection groups = this.manager.getConsumerGroups();
        RegistrationManagerTestCase.assertEquals((int)1, (int)groups.size());
        RegistrationManagerTestCase.assertTrue((boolean)groups.contains(group));
        RegistrationManagerTestCase.assertEquals((Object)group, (Object)this.manager.getConsumerGroup(groupName));
        try {
            groups.add(group);
            RegistrationManagerTestCase.fail((String)"Shouldn't be possible to directly modify group collection");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
    }

    public void testRemoveConsumerGroup() throws RegistrationException {
        String groupName = "name";
        ConsumerGroup group = this.manager.createConsumerGroup(groupName);
        this.manager.removeConsumerGroup(group);
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerGroup(groupName));
        this.manager.createConsumerGroup(groupName);
        this.manager.removeConsumerGroup(groupName);
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerGroup(groupName));
    }

    public void testCascadeRemovalOnConsumerGroupRemoval() throws Exception {
        String groupName = "group";
        String consumerName = "consumer";
        Consumer consumer = this.manager.addConsumerToGroupNamed(consumerName, groupName, true, true);
        String consumerIdentity = consumer.getId();
        Registration reg = this.manager.addRegistrationTo(consumerName, this.registrationProperties, this.expectations, false);
        String handle = reg.getRegistrationHandle();
        ConsumerGroup group = this.manager.getConsumerGroup(groupName);
        this.manager.removeConsumerGroup(group);
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity(consumerIdentity));
        RegistrationManagerTestCase.assertNull((Object)this.manager.getRegistration(handle));
    }

    public void testCascadeRemovalOnConsumerRemoval() throws Exception {
        String consumerName = "consumer";
        Consumer consumer = this.manager.createConsumer(consumerName);
        String consumerIdentity = consumer.getId();
        Registration reg = this.manager.addRegistrationTo(consumerName, this.registrationProperties, this.expectations, false);
        String handle = reg.getRegistrationHandle();
        this.manager.removeConsumer(consumer);
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerByIdentity(consumerIdentity));
        RegistrationManagerTestCase.assertNull((Object)this.manager.getRegistration(handle));
    }

    public void testRemoveSingleRegistration() throws Exception {
        String consumerName = "consumer";
        Consumer consumer = this.manager.createConsumer(consumerName);
        Registration reg = this.manager.addRegistrationTo(consumerName, this.registrationProperties, this.expectations, false);
        String handle = reg.getRegistrationHandle();
        RegistrationManagerTestCase.assertTrue((boolean)consumer.getRegistrations().contains(reg));
        this.manager.removeRegistration(handle);
        RegistrationManagerTestCase.assertTrue((!consumer.getRegistrations().contains(reg) ? 1 : 0) != 0);
        RegistrationManagerTestCase.assertNull((Object)this.manager.getRegistration(handle));
        RegistrationManagerTestCase.assertEquals((Object)RegistrationStatus.PENDING, (Object)consumer.getStatus());
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerFor(handle));
    }

    public void testRemoveRegistrationOnConsumerWithOtherRegistrations() throws Exception {
        String consumerName = "consumer";
        Consumer consumer = this.manager.createConsumer(consumerName);
        Registration reg = this.manager.addRegistrationTo(consumerName, this.registrationProperties, this.expectations, false);
        String handle = reg.getRegistrationHandle();
        RegistrationStatus status = consumer.getStatus();
        this.manager.removeRegistration(handle);
        RegistrationManagerTestCase.assertEquals((Object)status, (Object)consumer.getStatus());
        RegistrationManagerTestCase.assertNull((Object)this.manager.getConsumerFor(handle));
    }

    public void testAddRegistrationWithInvalidRegistrationProperties() throws Exception {
        String consumerName = "consumer";
        Consumer consumer = this.manager.createConsumer(consumerName);
        this.registrationProperties.put(new QName("prop3"), "value3");
        try {
            this.manager.addRegistrationTo(consumerName, this.registrationProperties, this.expectations, false);
            RegistrationManagerTestCase.fail((String)"Expectations does not contain prop3, so trying to register with a value for it should fail");
        }
        catch (RegistrationException e) {
            RegistrationManagerTestCase.assertTrue((boolean)e.getMessage().contains("prop3"));
            RegistrationManagerTestCase.assertEquals((int)0, (int)consumer.getRegistrations().size());
        }
    }

    public void testRemoveInexistentRegistration() throws RegistrationException {
        try {
            this.manager.removeRegistration((Registration)null);
            RegistrationManagerTestCase.fail((String)"Should be possible to remove a null registration");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.manager.removeRegistration((String)null);
            RegistrationManagerTestCase.fail((String)"Should be possible to remove a registration with a null handle");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.manager.removeRegistration("");
            RegistrationManagerTestCase.fail((String)"Should be possible to remove a registration with an empty handle");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.manager.removeRegistration("doesn't exist");
            RegistrationManagerTestCase.fail((String)"Should be possible to remove a registration with an invalid handle");
        }
        catch (NoSuchRegistrationException noSuchRegistrationException) {
            // empty catch block
        }
    }

    public void testClear() throws Exception {
        this.manager.createConsumer("c1");
        this.manager.createConsumer("c2");
        this.manager.addConsumerToGroupNamed("c1g1", "g1", true, true);
        this.manager.createConsumerGroup("g2");
        Registration r1 = this.manager.addRegistrationTo("c1", this.registrationProperties, this.expectations, false);
        Registration r2 = this.manager.addRegistrationTo("c3", this.registrationProperties, this.expectations, true);
        this.manager.clear();
        RegistrationManagerTestCase.assertTrue((boolean)this.manager.getConsumerGroups().isEmpty());
        RegistrationManagerTestCase.assertTrue((boolean)this.manager.getConsumers().isEmpty());
        RegistrationManagerTestCase.assertNull((Object)this.manager.getRegistration(r1.getRegistrationHandle()));
        RegistrationManagerTestCase.assertNull((Object)this.manager.getRegistration(r2.getRegistrationHandle()));
    }
}

