/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.pc.api.PortletContext;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.impl.RegistrationManagerImpl;
import org.gatein.registration.impl.RegistrationPersistenceManagerImpl;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.spi.RegistrationSPI;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.registration.PropertyDescription;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

public class RegistrationTestCase
extends TestCase {
    private RegistrationSPI registration;
    private Map<QName, Object> registrationProperties;

    protected void setUp() throws Exception {
        RegistrationManagerImpl manager = new RegistrationManagerImpl();
        DefaultRegistrationPolicy policy = new DefaultRegistrationPolicy(){

            public void validateRegistrationDataFor(Map<QName, Object> registrationProperties, String consumerIdentity, Map<QName, ? extends PropertyDescription> expectations, RegistrationManager manager) throws IllegalArgumentException, RegistrationException, DuplicateRegistrationException {
            }
        };
        manager.setPolicy((RegistrationPolicy)policy);
        manager.setPersistenceManager((RegistrationPersistenceManager)new RegistrationPersistenceManagerImpl());
        this.registrationProperties = new HashMap<QName, Object>();
        QName prop1Name = new QName("prop1");
        this.registrationProperties.put(prop1Name, "value1");
        QName prop2Name = new QName("prop2");
        this.registrationProperties.put(prop2Name, "value2");
        HashMap<QName, RegistrationPropertyDescription> expectations = new HashMap<QName, RegistrationPropertyDescription>();
        expectations.put(prop1Name, new RegistrationPropertyDescription(prop1Name, WSRPConstants.XSD_STRING));
        expectations.put(prop2Name, new RegistrationPropertyDescription(prop2Name, WSRPConstants.XSD_STRING));
        this.registration = (RegistrationSPI)manager.addRegistrationTo("name", this.registrationProperties, expectations, true);
    }

    public void testGetPropertiesIsUnmodifiable() {
        Map properties = this.registration.getProperties();
        try {
            properties.remove("foo");
            RegistrationTestCase.fail((String)"Properties shouldn't be directly modifiable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPropertiesAreClonedNotLive() {
        QName prop = new QName("prop3");
        this.registrationProperties.put(prop, "value3");
        RegistrationTestCase.assertNull(this.registration.getProperties().get(prop));
    }

    public void testSetNullPropertyValueThrowsIAE() {
        try {
            this.registration.setPropertyValueFor("foo", null);
            RegistrationTestCase.fail((String)"Shouldn't accept null values for properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetNullPropertyNameThrowsIAE() {
        try {
            this.registration.setPropertyValueFor((QName)null, null);
            RegistrationTestCase.fail((String)"Shouldn't accept null names for properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testProperties() {
        QName name = new QName("prop1");
        RegistrationTestCase.assertEquals((Object)"value1", this.registration.getProperties().get(name));
        RegistrationTestCase.assertEquals((Object)"value2", this.registration.getProperties().get(new QName("prop2")));
        String newValue = "new value";
        this.registration.setPropertyValueFor("prop1", (Object)newValue);
        RegistrationTestCase.assertEquals((Object)newValue, this.registration.getProperties().get(name));
        this.registration.removeProperty(name);
        RegistrationTestCase.assertNull((Object)this.registration.getPropertyValueFor(name));
    }

    public void testUpdateProperties() {
        this.registrationProperties.remove(new QName("prop1"));
        this.registration.updateProperties(this.registrationProperties);
        RegistrationTestCase.assertNull((Object)this.registration.getPropertyValueFor("prop1"));
        QName name = new QName("prop3");
        String value = "value3";
        this.registrationProperties.put(name, value);
        this.registration.updateProperties(this.registrationProperties);
        RegistrationTestCase.assertEquals((Object)value, (Object)this.registration.getPropertyValueFor(name));
    }

    public void testHasEqualProperties() {
        RegistrationTestCase.assertTrue((boolean)this.registration.hasEqualProperties((Registration)this.registration));
        RegistrationTestCase.assertTrue((boolean)this.registration.hasEqualProperties(this.registrationProperties));
        this.registrationProperties.put(new QName("prop3"), "value3");
        RegistrationTestCase.assertTrue((!this.registration.hasEqualProperties(this.registrationProperties) ? 1 : 0) != 0);
    }

    public void testPortletContextOperations() throws RegistrationException {
        PortletContext foo = PortletContext.createPortletContext((String)"webapp", (String)"foo");
        this.registration.addPortletContext(foo);
        RegistrationTestCase.assertTrue((boolean)this.registration.knows(foo));
        RegistrationTestCase.assertTrue((boolean)this.registration.knows(foo.getId()));
        Set knownPortletContexts = this.registration.getKnownPortletContexts();
        RegistrationTestCase.assertEquals((int)1, (int)knownPortletContexts.size());
        RegistrationTestCase.assertTrue((boolean)knownPortletContexts.contains(foo));
        this.registration.removePortletContext(foo);
        RegistrationTestCase.assertFalse((boolean)this.registration.knows(foo));
        RegistrationTestCase.assertFalse((boolean)this.registration.knows(foo.getId()));
        knownPortletContexts = this.registration.getKnownPortletContexts();
        RegistrationTestCase.assertTrue((boolean)knownPortletContexts.isEmpty());
    }
}

