/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration;

import junit.framework.TestCase;
import org.gatein.registration.RegistrationUtils;

public class RegistrationUtilsTestCase
extends TestCase {
    public void testValidateConsumerAgentStrict() {
        RegistrationUtils.setStrict((boolean)true);
        RegistrationUtils.validateConsumerAgent((String)"foo.bar.baz");
        RegistrationUtils.validateConsumerAgent((String)"foo.bar.baz.");
        RegistrationUtils.validateConsumerAgent((String)"foo.bar.baz. ");
        RegistrationUtils.validateConsumerAgent((String)"foo.bar.baz. dasfsafads");
        this.checkValidateProperlyRejects("goo");
        this.checkValidateProperlyRejects("goo.");
        this.checkValidateProperlyRejects("goo.boo");
        this.checkValidateProperlyRejects("goo.boo.");
        this.checkValidateProperlyRejects("goo.boo. ");
    }

    private void checkValidateProperlyRejects(String consumerAgent) {
        try {
            RegistrationUtils.validateConsumerAgent((String)consumerAgent);
            RegistrationUtilsTestCase.fail((String)("Should have rejected '" + consumerAgent + "' as an invalid Consumer Agent string"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateConsumerAgentLenient() {
        RegistrationUtils.setStrict((boolean)false);
        RegistrationUtils.validateConsumerAgent((String)"foo.bar.baz");
        RegistrationUtils.validateConsumerAgent((String)"goo");
        RegistrationUtils.validateConsumerAgent((String)"goo.");
        RegistrationUtils.validateConsumerAgent((String)"goo.boo");
        RegistrationUtils.validateConsumerAgent((String)"goo.boo.");
        RegistrationUtils.validateConsumerAgent((String)"goo.boo. ");
    }
}

