/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.policies;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.impl.RegistrationManagerImpl;
import org.gatein.registration.impl.RegistrationPersistenceManagerImpl;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.producer.config.TestRegistrationPropertyValidator;
import org.gatein.wsrp.registration.PropertyDescription;

public class DefaultRegistrationPolicyTestCase
extends TestCase {
    DefaultRegistrationPolicy policy;
    Map<QName, Object> registrationProperties;
    Map<QName, PropertyDescription> expectations;
    private static final String CONSUMER = "consumer";
    private static final QName PROP1 = new QName("prop1");
    private static final QName PROP2 = new QName("prop2");
    private static final QName PROP3 = new QName("prop3");
    private RegistrationManager manager;

    protected void setUp() throws Exception {
        this.policy = new DefaultRegistrationPolicy();
        this.policy.setValidator((RegistrationPropertyValidator)new DefaultRegistrationPropertyValidator());
        this.manager = new RegistrationManagerImpl();
        this.manager.setPolicy((RegistrationPolicy)this.policy);
        this.manager.setPersistenceManager((RegistrationPersistenceManager)new RegistrationPersistenceManagerImpl());
        this.manager.createConsumer(CONSUMER);
        this.registrationProperties = new HashMap<QName, Object>();
        this.registrationProperties.put(PROP1, "value1");
        this.registrationProperties.put(PROP2, "value2");
        this.expectations = new HashMap<QName, PropertyDescription>();
    }

    public void testInitialState() {
        DefaultRegistrationPolicy registrationPolicy = new DefaultRegistrationPolicy();
        DefaultRegistrationPolicyTestCase.assertEquals((Object)DefaultRegistrationPropertyValidator.DEFAULT, (Object)registrationPolicy.getValidator());
    }

    public void testValidateRegistrationDataForNull() throws RegistrationException {
        try {
            this.policy.validateRegistrationDataFor(null, "foo", this.expectations, this.manager);
            DefaultRegistrationPolicyTestCase.fail((String)"null data cannot be validated");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.policy.validateRegistrationDataFor(Collections.emptyMap(), null, this.expectations, this.manager);
            DefaultRegistrationPolicyTestCase.fail((String)"null data cannot be validated");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateRegistrationDataForInexistentConsumer() {
        try {
            this.policy.validateRegistrationDataFor(Collections.emptyMap(), "foo", this.expectations, this.manager);
        }
        catch (RegistrationException e) {
            DefaultRegistrationPolicyTestCase.fail((String)"Should be possible to validate information for inexistent consumer (otherwise, how would we register!)");
        }
    }

    public void testValidateRegistrationDataMissingProps() {
        this.expectations.put(PROP1, new TestPropertyDescription(PROP1));
        this.expectations.put(PROP2, new TestPropertyDescription(PROP2));
        this.expectations.put(PROP3, new TestPropertyDescription(PROP3));
        try {
            this.policy.validateRegistrationDataFor(this.registrationProperties, CONSUMER, this.expectations, this.manager);
            DefaultRegistrationPolicyTestCase.fail((String)"Missing prop3 should have been detected");
        }
        catch (RegistrationException e) {
            String message = e.getLocalizedMessage();
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)message.startsWith("Missing value for expected '"));
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)message.contains("prop3"));
        }
    }

    public void testValidateRegistrationDataFailedValidation() {
        this.expectations.put(PROP1, new TestPropertyDescription(PROP1));
        this.expectations.put(PROP2, new TestPropertyDescription(PROP2));
        this.policy.setValidator((RegistrationPropertyValidator)new TestRegistrationPropertyValidator());
        try {
            this.policy.validateRegistrationDataFor(this.registrationProperties, CONSUMER, this.expectations, this.manager);
            DefaultRegistrationPolicyTestCase.fail((String)"Should have rejected properties based on values");
        }
        catch (RegistrationException e) {
            String message = e.getLocalizedMessage();
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)message.startsWith("Invalid value for property '"));
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)message.contains("prop1"));
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)message.contains("prop2"));
        }
    }

    public void testValidateRegistrationDataExtraProps() {
        this.expectations.put(PROP1, new TestPropertyDescription(PROP1));
        try {
            this.policy.validateRegistrationDataFor(this.registrationProperties, CONSUMER, this.expectations, this.manager);
            DefaultRegistrationPolicyTestCase.fail((String)"Extra prop2 should have been detected");
        }
        catch (RegistrationException e) {
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)e.getLocalizedMessage().contains("prop2"));
        }
    }

    public void testValidateRegistrationDataInvalidValue() {
        this.expectations.put(PROP1, new TestPropertyDescription(PROP1));
        this.registrationProperties.remove(PROP2);
        this.registrationProperties.put(PROP1, null);
        try {
            this.policy.validateRegistrationDataFor(this.registrationProperties, CONSUMER, this.expectations, this.manager);
            DefaultRegistrationPolicyTestCase.fail((String)"Should have detected null value for prop1");
        }
        catch (RegistrationException e) {
            DefaultRegistrationPolicyTestCase.assertTrue((boolean)e.getLocalizedMessage().contains("prop1"));
        }
    }

    static class TestPropertyDescription
    implements PropertyDescription {
        private QName name;
        private static final QName TYPE = new QName("type");

        TestPropertyDescription(QName name) {
            this.name = name;
        }

        public QName getName() {
            return this.name;
        }

        public QName getType() {
            return TYPE;
        }

        public int compareTo(PropertyDescription o) {
            return this.name.toString().compareTo(o.getName().toString());
        }
    }
}

