/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.api.plugins.Plugins;
import org.gatein.wsrp.api.plugins.PluginsAccess;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationChangeListener;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.config.TestPlugins;
import org.gatein.wsrp.producer.config.TestRegistrationPolicy;
import org.gatein.wsrp.producer.config.impl.AbstractProducerConfigurationService;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

public abstract class ProducerConfigurationTestCase
extends TestCase {
    protected AbstractProducerConfigurationService service;

    public void testCustomPolicyUnmarshalling() throws Exception {
        ProducerConfiguration producerConfiguration = this.getProducerConfiguration("custom-policy.xml");
        ProducerConfigurationTestCase.assertTrue((boolean)producerConfiguration.isUsingStrictMode());
        ProducerRegistrationRequirements requirements = producerConfiguration.getRegistrationRequirements();
        ProducerConfigurationTestCase.assertNotNull((Object)requirements);
        RegistrationPolicy policy = requirements.getPolicy();
        ProducerConfigurationTestCase.assertTrue((boolean)policy.isWrapped());
        ProducerConfigurationTestCase.assertFalse((boolean)(policy instanceof TestRegistrationPolicy));
        ProducerConfigurationTestCase.assertEquals(TestRegistrationPolicy.class, RegistrationPolicyWrapper.unwrap((RegistrationPolicy)policy).getClass());
    }

    public void testExtendedUnmarshalling() throws Exception {
        ProducerConfiguration producerConfiguration = this.getProducerConfiguration("extended.xml");
        ProducerConfigurationTestCase.assertTrue((boolean)producerConfiguration.isUsingStrictMode());
        ProducerRegistrationRequirements requirements = producerConfiguration.getRegistrationRequirements();
        ProducerConfigurationTestCase.assertNotNull((Object)requirements);
        RegistrationPolicy policy = RegistrationPolicyWrapper.unwrap((RegistrationPolicy)requirements.getPolicy());
        ProducerConfigurationTestCase.assertTrue((boolean)(policy instanceof DefaultRegistrationPolicy));
        RegistrationPropertyValidator propertyValidator = ((DefaultRegistrationPolicy)policy).getValidator();
        ProducerConfigurationTestCase.assertNotNull((Object)propertyValidator);
        ProducerConfigurationTestCase.assertTrue((boolean)(propertyValidator instanceof DefaultRegistrationPropertyValidator));
        ProducerConfigurationTestCase.assertTrue((boolean)requirements.isRegistrationRequired());
        ProducerConfigurationTestCase.assertTrue((boolean)requirements.isRegistrationRequiredForFullDescription());
        Map properties = requirements.getRegistrationProperties();
        ProducerConfigurationTestCase.assertNotNull((Object)properties);
        ProducerConfigurationTestCase.assertEquals((int)2, (int)properties.size());
        this.checkRegistrationProperty(requirements, 1);
        this.checkRegistrationProperty(requirements, 2);
    }

    public void testMinimalRegistrationUnmarshalling() throws Exception {
        ProducerConfiguration producerConfiguration = this.getProducerConfiguration("minimal-registration.xml");
        ProducerConfigurationTestCase.assertTrue((boolean)producerConfiguration.isUsingStrictMode());
        ProducerRegistrationRequirements requirements = producerConfiguration.getRegistrationRequirements();
        ProducerConfigurationTestCase.assertNotNull((Object)requirements);
        ProducerConfigurationTestCase.assertTrue((boolean)requirements.isRegistrationRequired());
        ProducerConfigurationTestCase.assertTrue((!requirements.isRegistrationRequiredForFullDescription() ? 1 : 0) != 0);
        Map properties = requirements.getRegistrationProperties();
        ProducerConfigurationTestCase.assertNotNull((Object)properties);
        ProducerConfigurationTestCase.assertTrue((boolean)properties.isEmpty());
        ProducerConfigurationTestCase.assertNotNull((Object)requirements.getPolicy());
    }

    public void testMinimalUnmarshalling() throws Exception {
        ProducerConfiguration producerConfiguration = this.getProducerConfiguration("minimal.xml");
        ProducerConfigurationTestCase.assertTrue((boolean)producerConfiguration.isUsingStrictMode());
        ProducerRegistrationRequirements requirements = producerConfiguration.getRegistrationRequirements();
        ProducerConfigurationTestCase.assertNotNull((Object)requirements);
        ProducerConfigurationTestCase.assertFalse((boolean)requirements.isRegistrationRequired());
        ProducerConfigurationTestCase.assertFalse((boolean)requirements.isRegistrationRequiredForFullDescription());
        ProducerConfigurationTestCase.assertTrue((boolean)requirements.getRegistrationProperties().isEmpty());
        ProducerConfigurationTestCase.assertNotNull((Object)requirements.getPolicy());
    }

    public void testInvalidMultipleRegistrationConfiguration() throws Exception {
        try {
            this.getProducerConfiguration("invalid2.xml");
            ProducerConfigurationTestCase.fail((String)"Only one registration-configuration element allowed!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInvalidTypeValue() throws Exception {
        try {
            this.getProducerConfiguration("invalid-type.xml");
            ProducerConfigurationTestCase.fail((String)"Invalid type for property description should fail.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInvalidPropertyValidator() {
        try {
            this.getProducerConfiguration("invalid3.xml");
            ProducerConfigurationTestCase.fail((String)"Doesn't make sense to define a property validator if a registration policy other than DefaultRegistrationPolicy");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInvalidFullServiceDescriptionValue() {
        try {
            this.getProducerConfiguration("invalid1.xml");
            ProducerConfigurationTestCase.fail((String)"Invalid value for fullServiceDescriptionRequiresRegistration should have caused failure");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUseStrictMode() throws Exception {
        ProducerConfiguration producerConfiguration = this.getProducerConfiguration("strict-mode.xml");
        ProducerConfigurationTestCase.assertFalse((boolean)producerConfiguration.isUsingStrictMode());
    }

    public void testChangeListeners() throws Exception {
        ProducerConfiguration producerConfiguration = this.getProducerConfiguration("minimal.xml");
        ProducerConfigurationTestCase.assertTrue((boolean)producerConfiguration.isUsingStrictMode());
        TestProducerConfigurationChangeListener listener = new TestProducerConfigurationChangeListener();
        producerConfiguration.addChangeListener((ProducerConfigurationChangeListener)listener);
        ProducerConfigurationTestCase.assertFalse((boolean)listener.called);
        producerConfiguration.setUsingStrictMode(true);
        ProducerConfigurationTestCase.assertFalse((boolean)listener.called);
        producerConfiguration.setUsingStrictMode(false);
        ProducerConfigurationTestCase.assertFalse((boolean)producerConfiguration.isUsingStrictMode());
        ProducerConfigurationTestCase.assertTrue((boolean)listener.called);
    }

    public void testSaveAndReload() throws Exception {
        ProducerConfiguration configuration = this.getProducerConfiguration((URL)null);
        configuration.setUsingStrictMode(false);
        ProducerRegistrationRequirements registrationRequirements = configuration.getRegistrationRequirements();
        registrationRequirements.setRegistrationRequiredForFullDescription(true);
        registrationRequirements.setRegistrationRequired(true);
        String prop1 = "prop1";
        registrationRequirements.addEmptyRegistrationProperty(prop1);
        registrationRequirements.getRegistrationPropertyWith(prop1).setDefaultLabel("label1");
        String prop2 = "prop2";
        registrationRequirements.addEmptyRegistrationProperty(prop2);
        registrationRequirements.getRegistrationPropertyWith(prop2).setDefaultHint("hint2");
        String prop3 = "prop3";
        registrationRequirements.addEmptyRegistrationProperty(prop3);
        registrationRequirements.getRegistrationPropertyWith(prop3).setDefaultDescription("description3");
        String prop4 = "prop4";
        registrationRequirements.addEmptyRegistrationProperty(prop4);
        RegistrationPropertyDescription propDesc4 = registrationRequirements.getRegistrationPropertyWith(prop4);
        propDesc4.setDefaultLabel("label4");
        propDesc4.setDefaultHint("hint4");
        propDesc4.setDefaultDescription("description4");
        this.service.saveConfiguration();
        configuration = this.getProducerConfiguration(this.getConfigurationURL());
        ProducerConfigurationTestCase.assertFalse((boolean)configuration.isUsingStrictMode());
        registrationRequirements = configuration.getRegistrationRequirements();
        ProducerConfigurationTestCase.assertTrue((boolean)registrationRequirements.isRegistrationRequired());
        ProducerConfigurationTestCase.assertTrue((boolean)registrationRequirements.isRegistrationRequiredForFullDescription());
        ProducerConfigurationTestCase.assertEquals((int)4, (int)registrationRequirements.getRegistrationProperties().size());
        ProducerConfigurationTestCase.assertEquals((String)"label1", (String)registrationRequirements.getRegistrationPropertyWith(prop1).getLabel().getValue());
        ProducerConfigurationTestCase.assertEquals((String)"hint2", (String)registrationRequirements.getRegistrationPropertyWith(prop2).getHint().getValue());
        ProducerConfigurationTestCase.assertEquals((String)"description3", (String)registrationRequirements.getRegistrationPropertyWith(prop3).getDescription().getValue());
        propDesc4 = registrationRequirements.getRegistrationPropertyWith(prop4);
        ProducerConfigurationTestCase.assertEquals((String)"label4", (String)propDesc4.getLabel().getValue());
        ProducerConfigurationTestCase.assertEquals((String)"hint4", (String)propDesc4.getHint().getValue());
        ProducerConfigurationTestCase.assertEquals((String)"description4", (String)propDesc4.getDescription().getValue());
    }

    public void testCheckThatSavingWithModificationsProperlyChangesLastModified() throws Exception {
        ProducerConfiguration configuration = this.getProducerConfiguration((URL)null);
        configuration.setUsingStrictMode(false);
        ProducerRegistrationRequirements registrationRequirements = configuration.getRegistrationRequirements();
        registrationRequirements.setRegistrationRequiredForFullDescription(true);
        registrationRequirements.setRegistrationRequired(true);
        String prop1 = "prop1";
        registrationRequirements.addEmptyRegistrationProperty(prop1);
        registrationRequirements.getRegistrationPropertyWith(prop1).setDefaultLabel("label1");
        long initial = configuration.getLastModified();
        this.service.saveConfiguration();
        ProducerConfigurationTestCase.assertEquals((long)initial, (long)configuration.getLastModified());
        ProducerConfigurationTestCase.assertEquals((long)initial, (long)this.service.getPersistedLastModifiedForConfiguration());
        configuration.setUsingStrictMode(true);
        this.service.saveConfiguration();
        long lastModified = configuration.getLastModified();
        ProducerConfigurationTestCase.assertTrue((initial < lastModified ? 1 : 0) != 0);
        ProducerConfigurationTestCase.assertEquals((long)lastModified, (long)this.service.getPersistedLastModifiedForConfiguration());
        initial = lastModified;
        registrationRequirements.getRegistrationPropertyWith(prop1).setDefaultLabel("new label");
        this.service.saveConfiguration();
        lastModified = configuration.getLastModified();
        ProducerConfigurationTestCase.assertTrue((initial < lastModified ? 1 : 0) != 0);
        ProducerConfigurationTestCase.assertEquals((long)lastModified, (long)this.service.getPersistedLastModifiedForConfiguration());
        initial = lastModified;
        registrationRequirements.reloadPolicyFrom(TestRegistrationPolicy.class.getName(), null);
        this.service.saveConfiguration();
        lastModified = configuration.getLastModified();
        ProducerConfigurationTestCase.assertTrue((initial < lastModified ? 1 : 0) != 0);
        ProducerConfigurationTestCase.assertEquals((long)lastModified, (long)this.service.getPersistedLastModifiedForConfiguration());
    }

    protected abstract URL getConfigurationURL();

    protected ProducerConfiguration getProducerConfiguration(String fileName) throws Exception {
        URL location = Thread.currentThread().getContextClassLoader().getResource(fileName);
        ProducerConfigurationTestCase.assertNotNull((Object)location);
        System.out.println("Loading producer configuration = " + location);
        return this.getProducerConfiguration(location);
    }

    protected abstract ProducerConfiguration getProducerConfiguration(URL var1) throws Exception;

    private void checkRegistrationProperty(ProducerRegistrationRequirements requirements, int index) {
        RegistrationPropertyDescription desc = requirements.getRegistrationPropertyWith("name" + index);
        ProducerConfigurationTestCase.assertNotNull((Object)desc);
        ProducerConfigurationTestCase.assertEquals((Object)new QName("name" + index), (Object)desc.getName());
        ProducerConfigurationTestCase.assertEquals((Object)WSRPConstants.XSD_STRING, (Object)desc.getType());
        LocalizedString localizedString = new LocalizedString("hint" + index, Locale.ENGLISH);
        localizedString.setResourceName("resource.hint" + index);
        localizedString.setValue("hint" + index);
        ProducerConfigurationTestCase.assertEquals((Object)localizedString, (Object)desc.getHint());
        localizedString = new LocalizedString("label" + index, Locale.ENGLISH);
        localizedString.setResourceName("resource.label" + index);
        localizedString.setValue("label" + index);
        ProducerConfigurationTestCase.assertEquals((Object)localizedString, (Object)desc.getLabel());
    }

    static {
        if (PluginsAccess.getPlugins() == null) {
            PluginsAccess.register((Plugins)new TestPlugins());
        }
    }

    private static class TestProducerConfigurationChangeListener
    implements ProducerConfigurationChangeListener {
        boolean called = false;

        private TestProducerConfigurationChangeListener() {
        }

        public void usingStrictModeChangedTo(boolean strictMode) {
            this.called = true;
        }
    }
}

