/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationPolicyChangeListener;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.api.plugins.Plugins;
import org.gatein.wsrp.api.plugins.PluginsAccess;
import org.gatein.wsrp.producer.config.TestPlugins;
import org.gatein.wsrp.producer.config.TestRegistrationPolicy;
import org.gatein.wsrp.producer.config.impl.ProducerRegistrationRequirementsImpl;
import org.gatein.wsrp.registration.PropertyDescription;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

public class ProducerRegistrationRequirementsTestCase
extends TestCase {
    public void testSetRegistrationProperties() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.addEmptyRegistrationProperty("foo");
        requirements.addEmptyRegistrationProperty("bar");
        final ArrayList<RegistrationPropertyDescription> expected = new ArrayList<RegistrationPropertyDescription>();
        expected.add(new RegistrationPropertyDescription("newFoo", WSRPConstants.XSD_STRING));
        long lastModified = requirements.getLastModified();
        requirements.addRegistrationPropertyChangeListener(new RegistrationPropertyChangeListener(){

            public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> newRegistrationProperties) {
                Assert.assertEquals((int)expected.size(), (int)newRegistrationProperties.size());
                Assert.assertTrue((boolean)expected.containsAll(newRegistrationProperties.values()));
            }
        });
        requirements.setRegistrationProperties(expected);
        ProducerRegistrationRequirementsTestCase.assertTrue((requirements.getLastModified() > lastModified ? 1 : 0) != 0);
    }

    public void testChangeRegistrationPolicy() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.setRegistrationRequired(true);
        RegistrationPolicy policy = requirements.getPolicy();
        ProducerRegistrationRequirementsTestCase.assertTrue((boolean)policy.isWrapped());
        ProducerRegistrationRequirementsTestCase.assertFalse((boolean)(policy instanceof DefaultRegistrationPolicy));
        ProducerRegistrationRequirementsTestCase.assertEquals((String)"org.gatein.registration.policies.DefaultRegistrationPolicy", (String)policy.getClassName());
        requirements.reloadPolicyFrom("org.gatein.wsrp.producer.config.TestRegistrationPolicy", "org.gatein.registration.policies.DefaultRegistrationPropertyValidator");
        policy = requirements.getPolicy();
        ProducerRegistrationRequirementsTestCase.assertTrue((boolean)policy.isWrapped());
        ProducerRegistrationRequirementsTestCase.assertFalse((boolean)(policy instanceof TestRegistrationPolicy));
        ProducerRegistrationRequirementsTestCase.assertEquals((String)"org.gatein.wsrp.producer.config.TestRegistrationPolicy", (String)requirements.getPolicyClassName());
        ProducerRegistrationRequirementsTestCase.assertEquals((String)"org.gatein.wsrp.producer.config.TestRegistrationPolicy", (String)policy.getClassName());
        ProducerRegistrationRequirementsTestCase.assertNull((Object)requirements.getValidatorClassName());
    }

    public void testChangeToDefaultPolicyWithEmptyValidatorName() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.setRegistrationRequired(true);
        requirements.reloadPolicyFrom("org.gatein.registration.policies.DefaultRegistrationPolicy", "");
        RegistrationPolicy policy = requirements.getPolicy();
        ProducerRegistrationRequirementsTestCase.assertEquals((String)"org.gatein.registration.policies.DefaultRegistrationPolicy", (String)policy.getClassName());
        ProducerRegistrationRequirementsTestCase.assertEquals((String)"org.gatein.registration.policies.DefaultRegistrationPropertyValidator", (String)requirements.getValidatorClassName());
        DefaultRegistrationPolicy unwrap = (DefaultRegistrationPolicy)RegistrationPolicyWrapper.unwrap((RegistrationPolicy)policy);
        ProducerRegistrationRequirementsTestCase.assertTrue((boolean)(unwrap.getValidator() instanceof DefaultRegistrationPropertyValidator));
    }

    public void testSetUnchangedRegistrationProperties() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.addEmptyRegistrationProperty("foo");
        ArrayList<RegistrationPropertyDescription> expected = new ArrayList<RegistrationPropertyDescription>();
        expected.add(new RegistrationPropertyDescription("foo", WSRPConstants.XSD_STRING));
        long lastModified = requirements.getLastModified();
        requirements.addRegistrationPropertyChangeListener(new RegistrationPropertyChangeListener(){

            public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> newRegistrationProperties) {
                Assert.fail((String)"Shouldn't have been called!");
            }
        });
        requirements.setRegistrationProperties(expected);
        ProducerRegistrationRequirementsTestCase.assertEquals((long)lastModified, (long)requirements.getLastModified());
    }

    public void testSetRegistrationPropertiesPropertyRemoval() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.addEmptyRegistrationProperty("foo");
        final List expected = Collections.emptyList();
        long lastModified = requirements.getLastModified();
        requirements.addRegistrationPropertyChangeListener(new RegistrationPropertyChangeListener(){

            public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> newRegistrationProperties) {
                Assert.assertEquals((int)expected.size(), (int)newRegistrationProperties.size());
                Assert.assertTrue((boolean)expected.containsAll(newRegistrationProperties.values()));
            }
        });
        requirements.setRegistrationProperties(expected);
        ProducerRegistrationRequirementsTestCase.assertTrue((requirements.getLastModified() > lastModified ? 1 : 0) != 0);
    }

    public void testReloadSamePolicy() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.reloadPolicyFrom("org.gatein.registration.policies.DefaultRegistrationPolicy", "org.gatein.registration.policies.DefaultRegistrationPropertyValidator");
        requirements.addRegistrationPolicyChangeListener(new RegistrationPolicyChangeListener(){

            public void policyUpdatedTo(RegistrationPolicy policy) {
                Assert.fail((String)"Shouldn't have been called!");
            }
        });
        requirements.reloadPolicyFrom("org.gatein.registration.policies.DefaultRegistrationPolicy", "org.gatein.registration.policies.DefaultRegistrationPropertyValidator");
    }

    public void testSetRegistrationRequired() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.setRegistrationRequired(true);
        ProducerRegistrationRequirementsTestCase.assertTrue((boolean)requirements.isRegistrationRequired());
        requirements.addRegistrationPropertyChangeListener(new RegistrationPropertyChangeListener(){

            public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> newRegistrationProperties) {
                Assert.fail((String)"Shouldn't have been called!");
            }
        });
        requirements.setRegistrationRequired(true);
    }

    public void testRemoveProperty() {
        ProducerRegistrationRequirementsImpl requirements = new ProducerRegistrationRequirementsImpl();
        requirements.addEmptyRegistrationProperty("foo");
        long lastModified = requirements.getLastModified();
        requirements.removeRegistrationProperty("foo");
        requirements.addRegistrationPropertyChangeListener(new RegistrationPropertyChangeListener(){

            public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> newRegistrationProperties) {
                Assert.assertTrue((boolean)newRegistrationProperties.isEmpty());
            }
        });
        ProducerRegistrationRequirementsTestCase.assertTrue((requirements.getLastModified() > lastModified ? 1 : 0) != 0);
    }

    static {
        if (PluginsAccess.getPlugins() == null) {
            PluginsAccess.register((Plugins)new TestPlugins());
        }
    }
}

