/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.registration.Registration;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.handlers.processors.RenderRequestProcessor;
import org.gatein.wsrp.test.support.MockHttpServletRequest;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.gatein.wsrp.test.support.MockHttpSession;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;

public class MimeResponseProcessorTestCase
extends TestCase {
    private static final String PORTLET_HANDLE = "/app.portletHandle";

    public void testShouldUseProvidedNamespace() throws OperationFailed, UnsupportedMode, InvalidHandle, MissingParameters, UnsupportedMimeType, UnsupportedWindowState, InvalidRegistration, ModifyRegistrationRequired, UnsupportedLocale {
        String namespace = "namespace";
        ServletAccess.setRequestAndResponse((HttpServletRequest)MockHttpServletRequest.createMockRequest((HttpSession)MockHttpSession.createMockSession()), (HttpServletResponse)MockHttpServletResponse.createMockResponse());
        RenderRequestProcessor processor = new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)namespace), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), (List)WSRPConstants.getDefaultMimeTypes(), (String)"wsrp:view", (String)"wsrp:normal")));
        MimeResponseProcessorTestCase.assertEquals((String)"namespace", (String)processor.invocation.getWindowContext().getNamespace());
    }

    public void testShouldProperlyHandleWildCardsInRequestedMimeTypes() throws OperationFailed, UnsupportedMode, InvalidHandle, MissingParameters, UnsupportedMimeType, ModifyRegistrationRequired, UnsupportedWindowState, InvalidRegistration, UnsupportedLocale {
        ArrayList<String> mimeTypes = new ArrayList<String>(1);
        mimeTypes.add("*/*");
        ServletAccess.setRequestAndResponse((HttpServletRequest)MockHttpServletRequest.createMockRequest((HttpSession)MockHttpSession.createMockSession()), (HttpServletResponse)MockHttpServletResponse.createMockResponse());
        RenderRequestProcessor processor = new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns"), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), mimeTypes, (String)"wsrp:view", (String)"wsrp:normal")));
        MimeResponseProcessorTestCase.assertEquals((String)TestProducerHelper.PORTLET_MIME_TYPE, (String)processor.markupRequest.getMediaType());
        mimeTypes = new ArrayList(1);
        mimeTypes.add("*");
        processor = new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns"), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), mimeTypes, (String)"wsrp:view", (String)"wsrp:normal")));
        MimeResponseProcessorTestCase.assertEquals((String)TestProducerHelper.PORTLET_MIME_TYPE, (String)processor.markupRequest.getMediaType());
        mimeTypes = new ArrayList(1);
        mimeTypes.add("text/*");
        processor = new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns"), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), mimeTypes, (String)"wsrp:view", (String)"wsrp:normal")));
        MimeResponseProcessorTestCase.assertEquals((String)TestProducerHelper.PORTLET_MIME_TYPE, (String)processor.markupRequest.getMediaType());
        mimeTypes = new ArrayList(1);
        mimeTypes.add("image/*");
        try {
            new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns"), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), mimeTypes, (String)"wsrp:view", (String)"wsrp:normal")));
            MimeResponseProcessorTestCase.fail((String)"Should have failed on unsupported MIME type");
        }
        catch (UnsupportedMimeType unsupportedMimeType) {
            // empty catch block
        }
    }

    public void testShouldReturnFirstMimeTypeMatching() throws OperationFailed, UnsupportedMode, InvalidHandle, MissingParameters, UnsupportedMimeType, ModifyRegistrationRequired, UnsupportedWindowState, InvalidRegistration, UnsupportedLocale {
        ArrayList<String> mimeTypes = new ArrayList<String>(2);
        mimeTypes.add("text/xml");
        mimeTypes.add("text/*");
        ServletAccess.setRequestAndResponse((HttpServletRequest)MockHttpServletRequest.createMockRequest((HttpSession)MockHttpSession.createMockSession()), (HttpServletResponse)MockHttpServletResponse.createMockResponse());
        RenderRequestProcessor processor = new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns"), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), mimeTypes, (String)"wsrp:view", (String)"wsrp:normal")));
        MimeResponseProcessorTestCase.assertEquals((String)"text/xml", (String)processor.markupRequest.getMediaType());
        mimeTypes = new ArrayList(2);
        mimeTypes.add("image/*");
        mimeTypes.add("text/*");
        processor = new RenderRequestProcessor((ProducerHelper)new TestProducerHelper(), WSRPTypeFactory.createGetMarkup(null, (org.oasis.wsrp.v2.PortletContext)WSRPTypeFactory.createPortletContext((String)PORTLET_HANDLE), (RuntimeContext)WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns"), null, (MarkupParams)WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), mimeTypes, (String)"wsrp:view", (String)"wsrp:normal")));
        MimeResponseProcessorTestCase.assertEquals((String)TestProducerHelper.PORTLET_MIME_TYPE, (String)processor.markupRequest.getMediaType());
    }

    private static class TestProducerHelper
    implements ProducerHelper {
        static final String PORTLET_MIME_TYPE = MediaType.TEXT_HTML.getValue();

        private TestProducerHelper() {
        }

        public Portlet getPortletWith(PortletContext portletContext, Registration registration) throws InvalidHandle, PortletInvokerException {
            return new Portlet(){

                public PortletContext getContext() {
                    return PortletContext.createPortletContext((String)MimeResponseProcessorTestCase.PORTLET_HANDLE);
                }

                public PortletInfo getInfo() {
                    return null;
                }

                public boolean isRemote() {
                    return false;
                }
            };
        }

        public PortletDescription getPortletDescription(org.oasis.wsrp.v2.PortletContext portletContext, List<String> locales, Registration registration) throws InvalidHandle, OperationFailed {
            ArrayList<String> modeNames = new ArrayList<String>(1);
            modeNames.add("wsrp:view");
            ArrayList<String> windowStateNames = new ArrayList<String>(1);
            windowStateNames.add("wsrp:normal");
            ArrayList<MarkupType> markupTypes = new ArrayList<MarkupType>(1);
            markupTypes.add(WSRPTypeFactory.createMarkupType((String)PORTLET_MIME_TYPE, modeNames, windowStateNames, locales));
            markupTypes.add(WSRPTypeFactory.createMarkupType((String)"text/xml", modeNames, windowStateNames, locales));
            return WSRPTypeFactory.createPortletDescription((String)MimeResponseProcessorTestCase.PORTLET_HANDLE, markupTypes);
        }

        public PortletDescription getPortletDescription(Portlet portlet, List<String> locales) {
            throw new UnsupportedOperationException();
        }

        public Registration getRegistrationOrFailIfInvalid(RegistrationContext registrationContext) throws InvalidRegistration, OperationFailed {
            return null;
        }

        public void reset() {
        }
    }
}

