/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration;

import java.util.Locale;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.registration.ValueChangeListener;

public class RegistrationPropertyDescriptionTestCase
extends TestCase {
    private RegistrationPropertyDescription desc;

    protected void setUp() throws Exception {
        this.desc = new RegistrationPropertyDescription("foo", WSRPConstants.XSD_STRING);
    }

    public void testNotify() {
        TestParent parent = new TestParent();
        this.desc.setValueChangeListener((ValueChangeListener)parent);
        this.desc.setDefaultHint(null);
        RegistrationPropertyDescriptionTestCase.assertFalse((boolean)parent.notifyCalled);
        parent.resetNotifyCalled();
        this.desc.setDefaultHint("hint");
        RegistrationPropertyDescriptionTestCase.assertTrue((boolean)parent.notifyCalled);
    }

    public void testChangingNameUpdatesParent() {
        TestParent parent = new TestParent();
        this.desc.setValueChangeListener((ValueChangeListener)parent);
        RegistrationPropertyDescriptionTestCase.assertNotNull((Object)parent.getRegistrationPropertyWith("foo"));
        this.desc.setName(QName.valueOf("bar"));
        RegistrationPropertyDescriptionTestCase.assertEquals((Object)this.desc, (Object)parent.getRegistrationPropertyWith("bar"));
        RegistrationPropertyDescriptionTestCase.assertNull((Object)parent.getRegistrationPropertyWith("foo"));
    }

    public void testModifyIfNeeded() {
        String oldValue = "old";
        String newValue = "new";
        RegistrationPropertyDescriptionTestCase.assertEquals((Object)oldValue, (Object)this.desc.modifyIfNeeded((Object)oldValue, (Object)oldValue));
        RegistrationPropertyDescriptionTestCase.assertEquals((Object)newValue, (Object)this.desc.modifyIfNeeded((Object)oldValue, (Object)newValue));
        RegistrationPropertyDescriptionTestCase.assertEquals(null, (Object)this.desc.modifyIfNeeded(null, null));
        RegistrationPropertyDescriptionTestCase.assertEquals((Object)newValue, (Object)this.desc.modifyIfNeeded(null, (Object)newValue));
        RegistrationPropertyDescriptionTestCase.assertEquals(null, (Object)this.desc.modifyIfNeeded((Object)oldValue, null));
    }

    public void testGetLang() {
        RegistrationPropertyDescriptionTestCase.assertEquals((Object)Locale.getDefault(), (Object)this.desc.getLang());
        this.desc.setLabel(new LocalizedString("etiquette", Locale.FRENCH));
        RegistrationPropertyDescriptionTestCase.assertEquals((Object)Locale.FRENCH, (Object)this.desc.getLang());
    }

    class TestParent
    implements ValueChangeListener {
        private boolean notifyCalled;
        private String propName = "foo";

        TestParent() {
        }

        void resetNotifyCalled() {
            this.notifyCalled = false;
        }

        public RegistrationPropertyDescription getRegistrationPropertyWith(String name) {
            if (this.propName.equals(name)) {
                return RegistrationPropertyDescriptionTestCase.this.desc;
            }
            return null;
        }

        public void valueHasChanged(RegistrationPropertyDescription originating, Object oldValue, Object newValue, boolean isName) {
            String oldValueString;
            String string = oldValueString = oldValue == null ? null : oldValue.toString();
            if ("foo".equals(oldValueString)) {
                this.propName = originating.getName().getLocalPart();
            }
            this.notifyCalled = true;
        }
    }
}

