/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;
import org.jboss.jca.common.metadata.ds.XADataSourceImpl;
import org.jboss.logging.Messages;

public class ModifiableXaDataSource
extends DataSourceAbstractImpl
implements XaDataSource {
    private static final long serialVersionUID = -1401087499308709724L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final HashMap<String, String> xaDataSourceProperty;
    private String xaDataSourceClass;
    private final String driver;
    private final String newConnectionSql;
    private final CommonXaPool xaPool;
    private final Recovery recovery;

    public ModifiableXaDataSource(TransactionIsolation transactionIsolation, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlSelectorStrategyClassName, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useCcm, Map<String, String> xaDataSourceProperty, String xaDataSourceClass, String driver, String newConnectionSql, CommonXaPool xaPool, Recovery recovery) throws ValidateException {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm);
        if (xaDataSourceProperty != null) {
            this.xaDataSourceProperty = new HashMap(xaDataSourceProperty.size());
            this.xaDataSourceProperty.putAll(xaDataSourceProperty);
        } else {
            this.xaDataSourceProperty = new HashMap(0);
        }
        this.xaDataSourceClass = xaDataSourceClass;
        this.driver = driver;
        this.newConnectionSql = newConnectionSql;
        this.xaPool = xaPool;
        this.recovery = recovery;
        this.validate();
    }

    public final String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    public final String getDriver() {
        return this.driver;
    }

    public final Statement getStatement() {
        return this.statement;
    }

    public final String getUrlDelimiter() {
        return this.urlDelimiter;
    }

    public final String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public final String getNewConnectionSql() {
        return this.newConnectionSql;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.newConnectionSql == null ? 0 : this.newConnectionSql.hashCode());
        result = 31 * result + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = 31 * result + (this.xaDataSourceProperty == null ? 0 : this.xaDataSourceProperty.hashCode());
        result = 31 * result + (this.xaPool == null ? 0 : this.xaPool.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ModifiableXaDataSource)) {
            return false;
        }
        ModifiableXaDataSource other = (ModifiableXaDataSource)((Object)obj);
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.newConnectionSql == null ? other.newConnectionSql != null : !this.newConnectionSql.equals(other.newConnectionSql)) {
            return false;
        }
        if (this.xaDataSourceClass == null ? other.xaDataSourceClass != null : !this.xaDataSourceClass.equals(other.xaDataSourceClass)) {
            return false;
        }
        if (this.xaDataSourceProperty == null ? other.xaDataSourceProperty != null : !this.xaDataSourceProperty.equals(other.xaDataSourceProperty)) {
            return false;
        }
        return !(this.xaPool == null ? other.xaPool != null : !this.xaPool.equals(other.xaPool));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xa-datasource");
        if (this.jndiName != null) {
            sb.append(" ").append(XaDataSource.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append(XaDataSource.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append(XaDataSource.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append(XaDataSource.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.spy.booleanValue()) {
            sb.append(" ").append(XaDataSource.Attribute.SPY).append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm.booleanValue()) {
            sb.append(" ").append(XaDataSource.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        sb.append(">");
        if (this.xaDataSourceProperty != null && this.xaDataSourceProperty.size() > 0) {
            for (Map.Entry<String, String> entry : this.xaDataSourceProperty.entrySet()) {
                sb.append("<").append(XaDataSource.Tag.XA_DATASOURCE_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append(XaDataSource.Tag.XA_DATASOURCE_PROPERTY).append(">");
            }
        }
        if (this.xaDataSourceClass != null) {
            sb.append("<").append(XaDataSource.Tag.XA_DATASOURCE_CLASS).append(">");
            sb.append(this.xaDataSourceClass);
            sb.append("</").append(XaDataSource.Tag.XA_DATASOURCE_CLASS).append(">");
        }
        if (this.driver != null) {
            sb.append("<").append(XaDataSource.Tag.DRIVER).append(">");
            sb.append(this.driver);
            sb.append("</").append(XaDataSource.Tag.DRIVER).append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append(XaDataSource.Tag.URL_DELIMITER).append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append(XaDataSource.Tag.URL_DELIMITER).append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append(XaDataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append(XaDataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append(XaDataSource.Tag.NEW_CONNECTION_SQL).append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append(XaDataSource.Tag.NEW_CONNECTION_SQL).append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append(XaDataSource.Tag.TRANSACTION_ISOLATION).append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append(XaDataSource.Tag.TRANSACTION_ISOLATION).append(">");
        }
        if (this.xaPool != null) {
            sb.append(this.xaPool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        if (this.recovery != null) {
            sb.append(this.recovery);
        }
        sb.append("</xa-datasource>");
        return sb.toString();
    }

    public final Map<String, String> getXaDataSourceProperty() {
        return Collections.unmodifiableMap(this.xaDataSourceProperty);
    }

    public final void addXaDataSourceProperty(String name, String value) {
        this.xaDataSourceProperty.put(name, value);
    }

    public final CommonXaPool getXaPool() {
        return this.xaPool;
    }

    public void validate() throws ValidateException {
        if (!(this.xaDataSourceClass != null && this.xaDataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing(XaDataSource.Tag.XA_DATASOURCE_CLASS.getLocalName(), ((Object)((Object)this)).getClass().getCanonicalName()));
        }
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public final void forceXaDataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    public final XaDataSource getUnModifiableInstance() throws ValidateException {
        return new XADataSourceImpl(this.transactionIsolation, this.timeOut, this.security, this.statement, this.validation, this.urlDelimiter, this.urlSelectorStrategyClassName, this.useJavaContext, this.poolName, this.enabled, this.jndiName, this.spy, this.useCcm, this.xaDataSourceProperty, this.xaDataSourceClass, this.driver, this.newConnectionSql, this.xaPool, this.recovery);
    }
}

