/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.FlushingHandlerService;
import org.jboss.as.logging.handlers.HandlerAddProperties;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

public abstract class FlushingHandlerAddProperties<T extends FlushingHandlerService>
extends HandlerAddProperties<T> {
    protected FlushingHandlerAddProperties(List<String> attributes, AttributeDefinition ... attributeDefinitions) {
        super(attributes, FlushingHandlerAddProperties.join(attributeDefinitions, new AttributeDefinition[]{CommonAttributes.AUTOFLUSH}));
    }

    protected FlushingHandlerAddProperties(AttributeDefinition ... attributeDefinitions) {
        super(FlushingHandlerAddProperties.join(attributeDefinitions, new AttributeDefinition[]{CommonAttributes.AUTOFLUSH}));
    }

    @Override
    protected void updateRuntime(OperationContext context, ServiceBuilder<Handler> serviceBuilder, String name, T service, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode autoflush = CommonAttributes.AUTOFLUSH.resolveModelAttribute(context, model);
        if (autoflush.isDefined()) {
            ((FlushingHandlerService)service).setAutoFlush(autoflush.asBoolean());
        }
    }

    private static List<AttributeDefinition> join(AttributeDefinition[] supplied, AttributeDefinition ... added) {
        ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
        for (AttributeDefinition attr : added) {
            result.add(attr);
        }
        result.addAll(Arrays.asList(supplied));
        return result;
    }
}

