/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.io.UnsupportedEncodingException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public abstract class HandlerService<T extends Handler>
implements Service<T> {
    private FormatterSpec formatterSpec;
    private Level level;
    private String encoding;
    private Filter filter;
    private T value;

    public final synchronized void start(StartContext context) throws StartException {
        T handler = this.createHandler();
        this.value = handler;
        this.getFormatterSpec().apply((Handler)handler);
        Filter filter = this.getFilter();
        if (filter != null) {
            ((Handler)handler).setFilter(filter);
        }
        try {
            ((Handler)handler).setEncoding(this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        Level level = this.getLevel();
        if (level != null) {
            ((Handler)handler).setLevel(level);
        }
        this.start(context, handler);
    }

    public final synchronized void stop(StopContext context) {
        T handler = this.value;
        ((Handler)handler).close();
        ((Handler)handler).setLevel(Level.OFF);
        this.stop(context, handler);
        this.value = null;
    }

    public final synchronized T getValue() {
        return this.value;
    }

    protected abstract T createHandler() throws StartException;

    protected abstract void start(StartContext var1, T var2) throws StartException;

    protected void stop(StopContext context, T handler) {
    }

    public final synchronized Level getLevel() {
        return this.level;
    }

    public final synchronized void setLevel(Level level) {
        this.level = level;
        Object handler = this.getValue();
        if (handler != null) {
            ((Handler)handler).setLevel(level);
        }
    }

    public final synchronized String getEncoding() {
        return this.encoding;
    }

    public final synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
        Object handler = this.getValue();
        if (handler != null) {
            ((Handler)handler).setEncoding(encoding);
        }
    }

    public final synchronized FormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    public final synchronized void setFormatterSpec(FormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        Object handler = this.getValue();
        if (handler != null && formatterSpec != null) {
            formatterSpec.apply((Handler)handler);
        }
    }

    public final synchronized Filter getFilter() {
        return this.filter;
    }

    public final synchronized void setFilter(Filter filter) {
        this.filter = filter;
        Object handler = this.getValue();
        if (handler != null) {
            ((Handler)handler).setFilter(filter);
        }
    }
}

