/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import java.io.FileNotFoundException;
import org.jboss.as.logging.handlers.FlushingHandlerService;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Values;

abstract class AbstractFileHandlerService<T extends FileHandler>
extends FlushingHandlerService<T> {
    private final InjectedValue<String> fileName = new InjectedValue();
    private boolean append;

    AbstractFileHandlerService() {
    }

    @Override
    protected void start(StartContext context, T handler) throws StartException {
        handler.setAutoFlush(this.isAutoflush());
        handler.setAppend(this.append);
        try {
            handler.setFileName(this.getFileName());
        }
        catch (FileNotFoundException e) {
            throw new StartException((Throwable)e);
        }
    }

    public final synchronized boolean isAppend() {
        return this.append;
    }

    public final synchronized void setAppend(boolean append) {
        this.append = append;
        FileHandler handler = (FileHandler)this.getValue();
        if (handler != null) {
            handler.setAppend(append);
        }
    }

    public final synchronized void setFile(String path) throws FileNotFoundException {
        this.fileName.setValue(Values.immediateValue((Object)path));
        FileHandler handler = (FileHandler)this.getValue();
        if (handler != null) {
            handler.setFileName(path);
        }
    }

    public final synchronized String getFileName() {
        return (String)this.fileName.getValue();
    }

    public final synchronized Injector<String> getFileNameInjector() {
        return this.fileName;
    }
}

