/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.AbstractLogHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.FlushingHandlerService;
import org.jboss.as.logging.handlers.file.AbstractFileHandlerService;
import org.jboss.as.logging.handlers.file.FileHandlers;
import org.jboss.dmr.ModelNode;

public abstract class AbstractFileHandlerWriteAttributeHandler<T extends AbstractFileHandlerService<?>>
extends AbstractLogHandlerWriteAttributeHandler<T> {
    protected AbstractFileHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
        super(AbstractFileHandlerWriteAttributeHandler.joinUnique(attributes, new AttributeDefinition[]{CommonAttributes.APPEND, CommonAttributes.AUTOFLUSH, CommonAttributes.FILE}));
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, T handlerService) throws OperationFailedException {
        boolean requiresRestart = false;
        if (CommonAttributes.APPEND.getName().equals(attributeName)) {
            ((AbstractFileHandlerService)handlerService).setAppend(resolvedValue.asBoolean());
            return true;
        }
        if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            ((FlushingHandlerService)handlerService).setAutoFlush(resolvedValue.asBoolean());
        } else if (CommonAttributes.FILE.getName().equals(attributeName)) {
            requiresRestart = FileHandlers.changeFile(context, currentValue, resolvedValue, handlerName);
        }
        return requiresRestart;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, T handlerService) throws OperationFailedException {
        if (CommonAttributes.APPEND.getName().equals(attributeName)) {
            ((AbstractFileHandlerService)handlerService).setAppend(valueToRestore.asBoolean());
        } else if (CommonAttributes.AUTOFLUSH.getName().equals(attributeName)) {
            ((FlushingHandlerService)handlerService).setAutoFlush(valueToRestore.asBoolean());
        } else if (CommonAttributes.FILE.getName().equals(attributeName)) {
            FileHandlers.revertFileChange(context, valueToRestore, handlerName);
        }
    }
}

