/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.logging.handlers.file.AbstractFileHandlerService;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;

public final class SizeRotatingFileHandlerService
extends AbstractFileHandlerService<SizeRotatingFileHandler> {
    private int maxBackupIndex;
    private long rotateSize;

    @Override
    protected SizeRotatingFileHandler createHandler() throws StartException {
        return new SizeRotatingFileHandler();
    }

    @Override
    protected void start(StartContext context, SizeRotatingFileHandler handler) throws StartException {
        super.start(context, handler);
        handler.setMaxBackupIndex(this.maxBackupIndex);
        handler.setRotateSize(this.rotateSize);
    }

    public synchronized int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public synchronized void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
        SizeRotatingFileHandler handler = (SizeRotatingFileHandler)this.getValue();
        if (handler != null) {
            handler.setMaxBackupIndex(maxBackupIndex);
        }
    }

    public synchronized long getRotateSize() {
        return this.rotateSize;
    }

    public synchronized void setRotateSize(long rotateSize) {
        this.rotateSize = rotateSize;
        SizeRotatingFileHandler handler = (SizeRotatingFileHandler)this.getValue();
        if (handler != null) {
            handler.setRotateSize(rotateSize);
        }
    }
}

