/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WsuIdAllocator;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.action.EncryptionAction;
import org.apache.ws.security.action.SAMLTokenSignedAction;
import org.apache.ws.security.action.SAMLTokenUnsignedAction;
import org.apache.ws.security.action.SignatureAction;
import org.apache.ws.security.action.SignatureConfirmationAction;
import org.apache.ws.security.action.TimestampAction;
import org.apache.ws.security.action.UsernameTokenAction;
import org.apache.ws.security.action.UsernameTokenSignedAction;
import org.apache.ws.security.processor.BinarySecurityTokenProcessor;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedDataProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.SecurityContextTokenProcessor;
import org.apache.ws.security.processor.SignatureConfirmationProcessor;
import org.apache.ws.security.processor.SignatureProcessor;
import org.apache.ws.security.processor.TimestampProcessor;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.transform.STRTransformProvider;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.UUIDGenerator;
import org.apache.ws.security.validate.SamlAssertionValidator;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.apache.ws.security.validate.TimestampValidator;
import org.apache.ws.security.validate.UsernameTokenValidator;
import org.apache.ws.security.validate.Validator;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;

public class WSSConfig {
    private static final Log LOG;
    private static final Map<Integer, Class<?>> DEFAULT_ACTIONS;
    private static final Map<QName, Class<?>> DEFAULT_PROCESSORS;
    private static final Map<QName, Class<?>> DEFAULT_VALIDATORS;
    protected boolean wsiBSPCompliant = true;
    protected boolean precisionInMilliSeconds = true;
    protected boolean enableSignatureConfirmation = false;
    protected boolean timeStampStrict = true;
    protected String requiredPasswordType = null;
    protected int timeStampTTL = 300;
    protected int timeStampFutureTTL = 60;
    protected boolean handleCustomPasswordTypes = false;
    protected boolean allowNamespaceQualifiedPasswordTypes = false;
    protected int secretKeyLength = 16;
    protected boolean passwordsAreEncoded = false;
    public static final WsuIdAllocator DEFAULT_ID_ALLOCATOR;
    protected WsuIdAllocator idAllocator = DEFAULT_ID_ALLOCATOR;
    private final Map<Integer, Object> actionMap = new HashMap(DEFAULT_ACTIONS);
    private final Map<QName, Object> processorMap = new HashMap(DEFAULT_PROCESSORS);
    private final Map<QName, Object> validatorMap = new HashMap(DEFAULT_VALIDATORS);
    private static boolean addJceProviders;
    private static boolean staticallyInitialized;

    public static void setAddJceProviders(boolean value) {
        addJceProviders = value;
    }

    private static void setXmlSecIgnoreLineBreak() {
        boolean wasSet = false;
        try {
            wasSet = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
                    if (System.getProperty(lineBreakPropName) == null) {
                        System.setProperty(lineBreakPropName, "true");
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Throwable t) {
            // empty catch block
        }
        Init.init();
        if (!wasSet) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        Field f = XMLUtils.class.getDeclaredField("ignoreLineBreaks");
                        f.setAccessible(true);
                        f.set(null, Boolean.TRUE);
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized void init() {
        if (!staticallyInitialized) {
            WSSConfig.setXmlSecIgnoreLineBreak();
            if (addJceProviders) {
                AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        WSSConfig.addXMLDSigRI();
                        WSSConfig.addJceProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
                        Security.removeProvider("STRTransform");
                        WSSConfig.appendJceProvider("STRTransform", new STRTransformProvider());
                        return true;
                    }
                });
            }
            staticallyInitialized = true;
        }
    }

    private static void addXMLDSigRI() {
        try {
            WSSConfig.addXMLDSigRIInternal();
        }
        finally {
            return;
        }
    }

    public static void addXMLDSigRIInternal() {
        WSSConfig.addJceProvider("ApacheXMLDSig", (Provider)new XMLDSigRI());
    }

    public static WSSConfig getNewInstance() {
        WSSConfig.init();
        return new WSSConfig();
    }

    public boolean isWsiBSPCompliant() {
        return this.wsiBSPCompliant;
    }

    public void setWsiBSPCompliant(boolean wsiBSPCompliant) {
        this.wsiBSPCompliant = wsiBSPCompliant;
    }

    public boolean isPrecisionInMilliSeconds() {
        return this.precisionInMilliSeconds;
    }

    public void setPrecisionInMilliSeconds(boolean precisionInMilliSeconds) {
        this.precisionInMilliSeconds = precisionInMilliSeconds;
    }

    public boolean isEnableSignatureConfirmation() {
        return this.enableSignatureConfirmation;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public void setHandleCustomPasswordTypes(boolean handleCustomTypes) {
        this.handleCustomPasswordTypes = handleCustomTypes;
    }

    public boolean getHandleCustomPasswordTypes() {
        return this.handleCustomPasswordTypes;
    }

    public void setAllowNamespaceQualifiedPasswordTypes(boolean allowNamespaceQualifiedTypes) {
        this.allowNamespaceQualifiedPasswordTypes = allowNamespaceQualifiedTypes;
    }

    public boolean getAllowNamespaceQualifiedPasswordTypes() {
        return this.allowNamespaceQualifiedPasswordTypes;
    }

    public boolean isTimeStampStrict() {
        return this.timeStampStrict;
    }

    public void setTimeStampStrict(boolean timeStampStrict) {
        this.timeStampStrict = timeStampStrict;
    }

    public String getRequiredPasswordType() {
        return this.requiredPasswordType;
    }

    public void setRequiredPasswordType(String requiredPasswordType) {
        this.requiredPasswordType = requiredPasswordType;
    }

    public int getTimeStampTTL() {
        return this.timeStampTTL;
    }

    public void setTimeStampTTL(int timeStampTTL) {
        this.timeStampTTL = timeStampTTL;
    }

    public int getTimeStampFutureTTL() {
        return this.timeStampFutureTTL;
    }

    public void setTimeStampFutureTTL(int timeStampFutureTTL) {
        this.timeStampFutureTTL = timeStampFutureTTL;
    }

    public void setSecretKeyLength(int length) {
        this.secretKeyLength = length;
    }

    public int getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public WsuIdAllocator getIdAllocator() {
        return this.idAllocator;
    }

    public void setIdAllocator(WsuIdAllocator idAllocator) {
        this.idAllocator = idAllocator;
    }

    public Class<?> setAction(int code, Action action) {
        Object result = this.actionMap.put(code, action);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Action) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setAction(int code, Class<?> clazz) {
        Class<?> result = this.actionMap.put(code, clazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Action) {
            return result.getClass();
        }
        return null;
    }

    public Action getAction(int action) throws WSSecurityException {
        Object actionObject = this.actionMap.get(action);
        if (actionObject instanceof Class) {
            try {
                return (Action)((Class)actionObject).newInstance();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)t.getMessage(), t);
                }
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{((Class)actionObject).getName()}, t);
            }
        }
        if (actionObject instanceof Action) {
            return (Action)actionObject;
        }
        return null;
    }

    public Class<?> setProcessor(QName el, Processor processor) {
        Object result = this.processorMap.put(el, processor);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Processor) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setProcessor(QName el, Class<?> clazz) {
        Class<?> result = this.processorMap.put(el, clazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Processor) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setValidator(QName el, Validator validator) {
        Object result = this.validatorMap.put(el, validator);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Validator) {
            return result.getClass();
        }
        return null;
    }

    public Class<?> setValidator(QName el, Class<?> clazz) {
        Class<?> result = this.validatorMap.put(el, clazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Validator) {
            return result.getClass();
        }
        return null;
    }

    public Validator getValidator(QName el) throws WSSecurityException {
        Object validatorObject = this.validatorMap.get(el);
        if (validatorObject instanceof Class) {
            try {
                return (Validator)((Class)validatorObject).newInstance();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)t.getMessage(), t);
                }
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{((Class)validatorObject).getName()}, t);
            }
        }
        if (validatorObject instanceof Validator) {
            return (Validator)validatorObject;
        }
        return null;
    }

    public Processor getProcessor(QName el) throws WSSecurityException {
        Object processorObject = this.processorMap.get(el);
        if (processorObject instanceof Class) {
            try {
                return (Processor)((Class)processorObject).newInstance();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)t.getMessage(), t);
                }
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{((Class)processorObject).getName()}, t);
            }
        }
        if (processorObject instanceof Processor) {
            return (Processor)processorObject;
        }
        return null;
    }

    public static String addJceProvider(String name, String className) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                Class<Provider> clazz = Loader.loadClass(className, false, Provider.class);
                Provider provider = clazz.newInstance();
                return WSSConfig.addJceProvider(name, provider);
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + name + " could not be added: " + t.getMessage()), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    public static String addJceProvider(String name, Provider provider) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                int ret = 0;
                Provider[] provs = Security.getProviders();
                for (int i = 0; i < provs.length; ++i) {
                    if (!"SUN".equals(provs[i].getName()) && !"IBMJCE".equals(provs[i].getName())) continue;
                    ret = Security.insertProviderAt(provider, i + 2);
                    break;
                }
                if (ret == 0) {
                    ret = Security.insertProviderAt(provider, 2);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + provider.getName() + " - " + provider.getVersion() + " was added at position: " + ret));
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + name + " could not be added: " + t.getMessage()), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    public static String appendJceProvider(String name, String className) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                Class<Provider> clazz = Loader.loadClass(className, false, Provider.class);
                Provider provider = clazz.newInstance();
                int ret = Security.addProvider(provider);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + provider.getName() + " was added at position: " + ret));
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + name + " could not be added: " + t.getMessage()), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    public static String appendJceProvider(String name, Provider provider) {
        Provider currentProvider = Security.getProvider(name);
        if (currentProvider == null) {
            try {
                int ret = Security.addProvider(provider);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + provider.getName() + " was added at position: " + ret));
                }
                return provider.getName();
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The provider " + name + " could not be added: " + t.getMessage()), t);
                }
                return null;
            }
        }
        return currentProvider.getName();
    }

    static {
        HashMap<Serializable, Class> tmp;
        block8: {
            block7: {
                block6: {
                    LOG = LogFactory.getLog(WSSConfig.class);
                    tmp = new HashMap<Serializable, Class>();
                    try {
                        tmp.put(Integer.valueOf(1), UsernameTokenAction.class);
                        tmp.put(Integer.valueOf(4), EncryptionAction.class);
                        tmp.put(Integer.valueOf(2), SignatureAction.class);
                        tmp.put(Integer.valueOf(16), SAMLTokenSignedAction.class);
                        tmp.put(Integer.valueOf(8), SAMLTokenUnsignedAction.class);
                        tmp.put(Integer.valueOf(32), TimestampAction.class);
                        tmp.put(Integer.valueOf(64), UsernameTokenSignedAction.class);
                        tmp.put(Integer.valueOf(128), SignatureConfirmationAction.class);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                DEFAULT_ACTIONS = Collections.unmodifiableMap(tmp);
                tmp = new HashMap();
                try {
                    tmp.put(WSSecurityEngine.SAML_TOKEN, SAMLTokenProcessor.class);
                    tmp.put(WSSecurityEngine.SAML2_TOKEN, SAMLTokenProcessor.class);
                    tmp.put(WSSecurityEngine.ENCRYPTED_KEY, EncryptedKeyProcessor.class);
                    tmp.put(WSSecurityEngine.SIGNATURE, SignatureProcessor.class);
                    tmp.put(WSSecurityEngine.TIMESTAMP, TimestampProcessor.class);
                    tmp.put(WSSecurityEngine.USERNAME_TOKEN, UsernameTokenProcessor.class);
                    tmp.put(WSSecurityEngine.REFERENCE_LIST, ReferenceListProcessor.class);
                    tmp.put(WSSecurityEngine.SIGNATURE_CONFIRMATION, SignatureConfirmationProcessor.class);
                    tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02, DerivedKeyTokenProcessor.class);
                    tmp.put(WSSecurityEngine.DERIVED_KEY_TOKEN_05_12, (Class)tmp.get(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02));
                    tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02, SecurityContextTokenProcessor.class);
                    tmp.put(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12, (Class)tmp.get(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02));
                    tmp.put(WSSecurityEngine.BINARY_TOKEN, BinarySecurityTokenProcessor.class);
                    tmp.put(WSSecurityEngine.ENCRYPTED_DATA, EncryptedDataProcessor.class);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            DEFAULT_PROCESSORS = Collections.unmodifiableMap(tmp);
            tmp = new HashMap();
            try {
                tmp.put(WSSecurityEngine.SAML_TOKEN, SamlAssertionValidator.class);
                tmp.put(WSSecurityEngine.SAML2_TOKEN, SamlAssertionValidator.class);
                tmp.put(WSSecurityEngine.SIGNATURE, SignatureTrustValidator.class);
                tmp.put(WSSecurityEngine.TIMESTAMP, TimestampValidator.class);
                tmp.put(WSSecurityEngine.USERNAME_TOKEN, UsernameTokenValidator.class);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        DEFAULT_VALIDATORS = Collections.unmodifiableMap(tmp);
        DEFAULT_ID_ALLOCATOR = new WsuIdAllocator(){
            int i;

            private synchronized String next() {
                return Integer.toString(++this.i);
            }

            @Override
            public String createId(String prefix, Object o) {
                if (prefix == null) {
                    return this.next();
                }
                return prefix + this.next();
            }

            @Override
            public String createSecureId(String prefix, Object o) {
                if (prefix == null) {
                    return UUIDGenerator.getUUID();
                }
                return prefix + UUIDGenerator.getUUID();
            }
        };
        addJceProviders = true;
        staticallyInitialized = false;
    }
}

