/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.osgi.repository.ArtifactProviderPlugin;
import org.jboss.osgi.repository.RepositoryResolutionException;
import org.jboss.osgi.resolver.v2.MavenCoordinates;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.XResourceBuilder;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;

public class MavenArtifactProvider
implements ArtifactProviderPlugin {
    private static Logger log = Logger.getLogger(MavenArtifactProvider.class);
    private static String JBOSS_NEXUS_BASE = "http://repository.jboss.org/nexus/content/groups/public";
    private static String MAVEN_CENTRAL_BASE = "http://repo1.maven.org/maven2";
    private final URL[] baserepos;

    public MavenArtifactProvider() {
        ArrayList<URL> repos = new ArrayList<URL>();
        String userhome = System.getProperty("user.home");
        File localrepo = new File(userhome + File.separator + ".m2" + File.separator + "repository");
        if (localrepo.isDirectory()) {
            repos.add(this.getBaseURL(localrepo.toURI().toString()));
        }
        repos.add(this.getBaseURL(JBOSS_NEXUS_BASE));
        repos.add(this.getBaseURL(MAVEN_CENTRAL_BASE));
        this.baserepos = repos.toArray(new URL[repos.size()]);
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        ArrayList<XIdentityCapability> result = new ArrayList<XIdentityCapability>();
        if ("maven.identity".equals(namespace)) {
            String mavenId = (String)req.getAttributes().get("maven.identity");
            MavenCoordinates coordinates = MavenCoordinates.parse((String)mavenId);
            try {
                for (URL baseURL : this.baserepos) {
                    URL url = coordinates.toArtifactURL(baseURL);
                    try {
                        url.openStream().close();
                        String contentPath = url.toExternalForm();
                        contentPath = contentPath.substring(baseURL.toExternalForm().length());
                        XResource resource = XResourceBuilder.create((URL)baseURL, (String)contentPath).getResource();
                        result.add(resource.getIdentityCapability());
                        break;
                    }
                    catch (IOException e) {
                    }
                }
            }
            catch (Exception ex) {
                throw new RepositoryResolutionException((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private URL getBaseURL(String basestr) {
        URL baseURL = null;
        try {
            baseURL = new URL(basestr);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return baseURL;
    }
}

