/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.cpr.AtmosphereServlet;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyCometSupportWithWebSocket
extends Jetty7CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JettyCometSupportWithWebSocket.class);
    private final WebSocketFactory webSocketFactory;

    public JettyCometSupportWithWebSocket(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
        Object wsf;
        String[] jettyVersion = config.getServletContext().getServerInfo().substring(6).split("\\.");
        try {
            wsf = Integer.valueOf(jettyVersion[0]) > 7 || Integer.valueOf(jettyVersion[0]) == 7 && Integer.valueOf(jettyVersion[1]) > 4 ? JettyWebSocketUtil.getFactory(config) : null;
        }
        catch (Throwable e) {
            logger.trace("Unable to parse Jetty version {}", (Object)config.getServletContext().getServerInfo());
            wsf = JettyWebSocketUtil.getFactory(config);
        }
        this.webSocketFactory = wsf;
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = JettyWebSocketUtil.doService(this, req, res, this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

