/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BroadcasterFuture<E>
implements Future {
    private final CountDownLatch latch;
    private boolean isCancelled = false;
    private boolean isDone = false;
    private final E msg;
    private final Future<?> innerFuture;

    public BroadcasterFuture(E msg) {
        this(null, msg);
    }

    public BroadcasterFuture(Future<?> innerFuture, E msg) {
        this.msg = msg;
        this.innerFuture = innerFuture;
        this.latch = innerFuture == null ? new CountDownLatch(1) : null;
    }

    @Override
    public boolean cancel(boolean b) {
        if (this.innerFuture != null) {
            return this.innerFuture.cancel(b);
        }
        if (this.latch.getCount() == 1L) {
            this.latch.countDown();
            this.isCancelled = true;
        }
        return this.isCancelled;
    }

    @Override
    public boolean isCancelled() {
        if (this.innerFuture != null) {
            return this.innerFuture.isCancelled();
        }
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        if (this.innerFuture != null) {
            return this.innerFuture.isDone();
        }
        this.isDone = true;
        return this.isDone;
    }

    public void done() {
        this.isDone = true;
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    public E get() throws InterruptedException, ExecutionException {
        if (this.innerFuture != null) {
            return (E)this.innerFuture.get();
        }
        this.latch.await();
        return this.msg;
    }

    public E get(long l, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.innerFuture != null) {
            return (E)this.innerFuture.get();
        }
        this.latch.await(l, tu);
        return this.msg;
    }
}

