/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.DeploymentScannerLogger;
import org.jboss.as.server.deployment.scanner.DeploymentScannerMessages;
import org.jboss.as.server.deployment.scanner.ExtensibleFilter;
import org.jboss.as.server.deployment.scanner.XmlCompletionScanner;
import org.jboss.as.server.deployment.scanner.ZipCompletionScanner;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class FileSystemDeploymentService
implements DeploymentScanner {
    private static final Pattern ARCHIVE_PATTERN = Pattern.compile("^.*\\.[SsWwJjEeRr][Aa][Rr]$");
    static final String DEPLOYED = ".deployed";
    static final String FAILED_DEPLOY = ".failed";
    static final String DO_DEPLOY = ".dodeploy";
    static final String DEPLOYING = ".isdeploying";
    static final String UNDEPLOYING = ".isundeploying";
    static final String UNDEPLOYED = ".undeployed";
    static final String SKIP_DEPLOY = ".skipdeploy";
    static final String PENDING = ".pending";
    static final String WEB_INF = "WEB-INF";
    static final String META_INF = "META-INF";
    static final long MAX_NO_PROGRESS = 60000L;
    static final long DEFAULT_DEPLOYMENT_TIMEOUT = 600L;
    private File deploymentDir;
    private long scanInterval = 0L;
    private volatile boolean scanEnabled = false;
    private volatile boolean firstScan = true;
    private ScheduledFuture<?> scanTask;
    private ScheduledFuture<?> rescanIncompleteTask;
    private final Lock scanLock = new ReentrantLock();
    private final Map<String, DeploymentMarker> deployed = new HashMap<String, DeploymentMarker>();
    private final HashSet<String> ignoredMissingDeployments = new HashSet();
    private final HashSet<String> noticeLogged = new HashSet();
    private final HashSet<String> illegalDirLogged = new HashSet();
    private final HashSet<String> prematureExplodedContentDeletionLogged = new HashSet();
    private final HashSet<File> nonscannableLogged = new HashSet();
    private final Map<File, IncompleteDeploymentStatus> incompleteDeployments = new HashMap<File, IncompleteDeploymentStatus>();
    private final ScheduledExecutorService scheduledExecutor;
    private final ModelControllerClient controllerClient;
    private FileFilter filter = new ExtensibleFilter();
    private volatile boolean autoDeployZip;
    private volatile boolean autoDeployExploded;
    private volatile boolean autoDeployXml;
    private volatile long maxNoProgress = 60000L;
    private volatile long deploymentTimeout = 600L;
    private final String relativeTo;
    private final String relativePath;
    private final DeploymentScanRunnable scanRunnable = new DeploymentScanRunnable();

    FileSystemDeploymentService(String relativeTo, File deploymentDir, File relativeToDir, ModelControllerClient controllerClient, ScheduledExecutorService scheduledExecutor) throws OperationFailedException {
        if (scheduledExecutor == null) {
            throw DeploymentScannerMessages.MESSAGES.nullVar("scheduledExecutor");
        }
        if (controllerClient == null) {
            throw DeploymentScannerMessages.MESSAGES.nullVar("controllerClient");
        }
        if (deploymentDir == null) {
            throw DeploymentScannerMessages.MESSAGES.nullVar("deploymentDir");
        }
        if (!deploymentDir.exists()) {
            throw DeploymentScannerMessages.MESSAGES.directoryDoesNotExist(deploymentDir.getAbsolutePath());
        }
        if (!deploymentDir.isDirectory()) {
            throw DeploymentScannerMessages.MESSAGES.notADirectory(deploymentDir.getAbsolutePath());
        }
        if (!deploymentDir.canWrite()) {
            throw DeploymentScannerMessages.MESSAGES.directoryNotWritable(deploymentDir.getAbsolutePath());
        }
        this.relativeTo = relativeTo;
        this.deploymentDir = deploymentDir;
        this.controllerClient = controllerClient;
        this.scheduledExecutor = scheduledExecutor;
        if (relativeToDir != null) {
            String relDir;
            String fullDir = deploymentDir.getAbsolutePath();
            String sub = fullDir.substring((relDir = relativeToDir.getAbsolutePath()).length());
            if (sub.startsWith(File.separator)) {
                sub = sub.length() == 1 ? "" : sub.substring(1);
            }
            this.relativePath = sub.length() > 0 ? sub + File.separator : sub;
        } else {
            this.relativePath = null;
        }
        this.establishDeployedContentList(deploymentDir);
    }

    @Override
    public boolean isAutoDeployZippedContent() {
        return this.autoDeployZip;
    }

    @Override
    public void setAutoDeployZippedContent(boolean autoDeployZip) {
        this.autoDeployZip = autoDeployZip;
    }

    @Override
    public boolean isAutoDeployExplodedContent() {
        return this.autoDeployExploded;
    }

    @Override
    public void setAutoDeployExplodedContent(boolean autoDeployExploded) {
        if (autoDeployExploded && !this.autoDeployExploded) {
            DeploymentScannerLogger.ROOT_LOGGER.explodedAutoDeploymentContentWarning(DO_DEPLOY, "auto-deploy-exploded");
        }
        this.autoDeployExploded = autoDeployExploded;
    }

    @Override
    public void setAutoDeployXMLContent(boolean autoDeployXML) {
        this.autoDeployXml = autoDeployXML;
    }

    @Override
    public boolean isAutoDeployXMLContent() {
        return this.autoDeployXml;
    }

    @Override
    public boolean isEnabled() {
        return this.scanEnabled;
    }

    @Override
    public long getScanInterval() {
        return this.scanInterval;
    }

    @Override
    public synchronized void setScanInterval(long scanInterval) {
        if (scanInterval != this.scanInterval) {
            this.cancelScan();
        }
        this.scanInterval = scanInterval;
        this.startScan();
    }

    @Override
    public void setDeploymentTimeout(long deploymentTimeout) {
        this.deploymentTimeout = deploymentTimeout;
    }

    @Override
    public synchronized void startScanner() {
        boolean scanEnabled = this.scanEnabled;
        if (scanEnabled) {
            return;
        }
        this.scanEnabled = true;
        this.startScan();
        DeploymentScannerLogger.ROOT_LOGGER.started(this.getClass().getSimpleName(), this.deploymentDir.getAbsolutePath());
    }

    @Override
    public synchronized void stopScanner() {
        this.scanEnabled = false;
        this.cancelScan();
        this.safeClose((Closeable)this.controllerClient);
    }

    void setMaxNoProgress(long max) {
        this.maxNoProgress = max;
    }

    private void establishDeployedContentList(File dir) throws OperationFailedException {
        Set<String> deploymentNames = this.getDeploymentNames();
        File[] children = dir.listFiles();
        if (children == null || children.length == 0) {
            return;
        }
        for (File child : children) {
            File skipDeploy;
            String fileName = child.getName();
            if (child.isDirectory()) {
                if (this.isEEArchive(fileName)) continue;
                this.establishDeployedContentList(child);
                continue;
            }
            if (!fileName.endsWith(DEPLOYED)) continue;
            String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
            if (deploymentNames.contains(deploymentName)) {
                File deployment = new File(dir, deploymentName);
                this.deployed.put(deploymentName, new DeploymentMarker(child.lastModified(), !deployment.isDirectory()));
                continue;
            }
            if (!child.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(fileName);
            }
            if ((skipDeploy = new File(dir, deploymentName + SKIP_DEPLOY)).exists()) continue;
            File deployedMarker = new File(dir, deploymentName + DO_DEPLOY);
            this.createMarkerFile(deployedMarker, deploymentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        block36: {
            try {
                this.scanLock.lockInterruptibly();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            boolean scheduleRescan = false;
            try {
                if (!this.scanEnabled) break block36;
                DeploymentScannerLogger.ROOT_LOGGER.tracef("Scanning directory %s for deployment content changes", this.deploymentDir.getAbsolutePath());
                ScanContext scanContext = new ScanContext();
                this.scanDirectory(this.deploymentDir, this.relativePath, scanContext);
                this.ignoredMissingDeployments.retainAll(scanContext.ignoredMissingDeployments);
                for (String deploymentName : scanContext.ignoredMissingDeployments) {
                    if (!this.ignoredMissingDeployments.add(deploymentName)) continue;
                    DeploymentScannerLogger.ROOT_LOGGER.deploymentNotFound(deploymentName);
                }
                this.noticeLogged.retainAll(scanContext.nonDeployable);
                for (Object fileName : scanContext.nonDeployable) {
                    if (!this.noticeLogged.add((String)fileName)) continue;
                    DeploymentScannerLogger.ROOT_LOGGER.deploymentTriggered((String)fileName, DO_DEPLOY);
                }
                this.illegalDirLogged.retainAll(scanContext.illegalDir);
                for (Object fileName : scanContext.illegalDir) {
                    if (!this.illegalDirLogged.add((String)fileName)) continue;
                    DeploymentScannerLogger.ROOT_LOGGER.invalidExplodedDeploymentDirectory((String)fileName, this.deploymentDir.getAbsolutePath());
                }
                this.prematureExplodedContentDeletionLogged.retainAll(scanContext.prematureExplodedDeletions);
                for (Object fileName : scanContext.prematureExplodedDeletions) {
                    if (!this.prematureExplodedContentDeletionLogged.add((String)fileName)) continue;
                    DeploymentScannerLogger.ROOT_LOGGER.explodedDeploymentContentDeleted((String)fileName, DEPLOYED);
                }
                ScanStatus status = this.handleAutoDeployFailures(scanContext);
                if (status != ScanStatus.PROCEED) {
                    if (status == ScanStatus.RETRY && this.scanInterval > 1000L) {
                        scheduleRescan = true;
                    }
                    return;
                }
                ArrayList<UndeployTask> scannerTasks = scanContext.scannerTasks;
                for (String missing : scanContext.toRemove) {
                    File file = this.deploymentDir;
                    scannerTasks.add(new UndeployTask(missing, file, scanContext.scanStartTime));
                }
                if (scannerTasks.size() > 0) {
                    ArrayList<Object> updates = new ArrayList<ModelNode>(scannerTasks.size());
                    for (ScannerTask scannerTask : scannerTasks) {
                        scannerTask.recordInProgress();
                        ModelNode update = scannerTask.getUpdate();
                        if (DeploymentScannerLogger.ROOT_LOGGER.isDebugEnabled()) {
                            DeploymentScannerLogger.ROOT_LOGGER.debugf("Deployment scan of [%s] found update action [%s]", this.deploymentDir, update);
                        }
                        updates.add(update);
                    }
                    while (!updates.isEmpty()) {
                        ModelNode failure;
                        ModelNode results;
                        ModelNode composite = this.getCompositeUpdate(updates);
                        DeploymentTask deploymentTask = new DeploymentTask(new OperationBuilder(composite).build());
                        Future<ModelNode> futureResults = this.scheduledExecutor.submit(deploymentTask);
                        try {
                            results = futureResults.get(this.deploymentTimeout, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException e) {
                            futureResults.cancel(true);
                            failure = new ModelNode();
                            failure.get("outcome").set("failed");
                            failure.get("failure-description").set(DeploymentScannerMessages.MESSAGES.deploymentTimeout(this.deploymentTimeout));
                            for (ScannerTask scannerTask : scannerTasks) {
                                scannerTask.handleFailureResult(failure);
                            }
                            break;
                        }
                        catch (Exception e) {
                            DeploymentScannerLogger.ROOT_LOGGER.fileSystemDeploymentFailed(e);
                            futureResults.cancel(true);
                            failure = new ModelNode();
                            failure.get("outcome").set("failed");
                            failure.get("failure-description").set(e.getMessage());
                            for (ScannerTask scannerTask : scannerTasks) {
                                scannerTask.handleFailureResult(failure);
                            }
                            break;
                        }
                        List resultList = results.get("result").asPropertyList();
                        ArrayList toRetry = new ArrayList();
                        ArrayList<UndeployTask> retryTasks = new ArrayList<UndeployTask>();
                        for (int i = 0; i < resultList.size(); ++i) {
                            ModelNode result = ((Property)resultList.get(i)).getValue();
                            ScannerTask task = (ScannerTask)scannerTasks.get(i);
                            ModelNode outcome = result.get("outcome");
                            if (outcome.isDefined() && "success".equals(outcome.asString())) {
                                task.handleSuccessResult();
                                continue;
                            }
                            if (outcome.isDefined() && "cancelled".equals(outcome.asString())) {
                                toRetry.add(updates.get(i));
                                retryTasks.add((UndeployTask)task);
                                continue;
                            }
                            task.handleFailureResult(result);
                        }
                        updates = toRetry;
                        scannerTasks = retryTasks;
                    }
                }
                DeploymentScannerLogger.ROOT_LOGGER.tracef("Scan complete", new Object[0]);
                this.firstScan = false;
            }
            finally {
                this.scanLock.unlock();
                if (scheduleRescan) {
                    Object fileName;
                    fileName = this;
                    synchronized (fileName) {
                        if (this.scanEnabled) {
                            this.rescanIncompleteTask = this.scheduledExecutor.schedule(this.scanRunnable, 200L, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            }
        }
    }

    private void scanDirectory(File directory, String relativePath, ScanContext scanContext) {
        File[] children = directory.listFiles(this.filter);
        if (children == null) {
            return;
        }
        for (File child : children) {
            File deploymentFile;
            String fileName = child.getName();
            if (fileName.endsWith(DEPLOYED)) {
                boolean autoDeployable;
                String deploymentName = fileName.substring(0, fileName.length() - DEPLOYED.length());
                DeploymentMarker deploymentMarker = this.deployed.get(deploymentName);
                if (deploymentMarker == null) {
                    scanContext.toRemove.remove(deploymentName);
                    this.removeExtraneousMarker(child, fileName);
                    continue;
                }
                deploymentFile = new File(directory, deploymentName);
                if (deploymentFile.exists()) {
                    scanContext.toRemove.remove(deploymentName);
                    if (this.deployed.get(deploymentName).lastModified == child.lastModified()) continue;
                    scanContext.scannerTasks.add(new RedeployTask(deploymentName, child.lastModified(), directory, !child.isDirectory()));
                    continue;
                }
                boolean bl = autoDeployable = deploymentMarker.archive ? this.autoDeployZip : this.autoDeployExploded;
                if (autoDeployable) continue;
                scanContext.toRemove.remove(deploymentName);
                if (deploymentMarker.archive) continue;
                scanContext.prematureExplodedDeletions.add(deploymentName);
                continue;
            }
            if (fileName.endsWith(DO_DEPLOY) || fileName.endsWith(FAILED_DEPLOY) && this.firstScan) {
                String markerStatus = fileName.endsWith(DO_DEPLOY) ? DO_DEPLOY : FAILED_DEPLOY;
                String deploymentName = fileName.substring(0, fileName.length() - markerStatus.length());
                if (FAILED_DEPLOY.equals(markerStatus)) {
                    DeploymentScannerLogger.ROOT_LOGGER.reattemptingFailedDeployment(deploymentName);
                }
                if (!(deploymentFile = new File(directory, deploymentName)).exists()) {
                    scanContext.ignoredMissingDeployments.add(deploymentName);
                    continue;
                }
                long timestamp = this.getDeploymentTimestamp(deploymentFile);
                String path = this.relativeTo == null ? deploymentFile.getAbsolutePath() : relativePath + deploymentName;
                boolean archive = deploymentFile.isFile();
                this.addContentAddingTask(path, archive, deploymentName, deploymentFile, timestamp, scanContext);
                continue;
            }
            if (fileName.endsWith(FAILED_DEPLOY)) {
                String deploymentName = fileName.substring(0, fileName.length() - FAILED_DEPLOY.length());
                scanContext.toRemove.remove(deploymentName);
                if (this.deployed.containsKey(deploymentName) || new File(child.getParent(), deploymentName).exists()) continue;
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (this.isEEArchive(fileName)) {
                boolean autoDeployable;
                boolean bl = autoDeployable = child.isDirectory() ? this.autoDeployExploded : this.autoDeployZip;
                if (autoDeployable) {
                    DeploymentMarker marker;
                    long timestamp;
                    if (this.isAutoDeployDisabled(child) || this.isFailedOrUndeployed(directory, fileName, timestamp = this.getDeploymentTimestamp(child)) || (marker = this.deployed.get(fileName)) != null && marker.lastModified == timestamp) continue;
                    try {
                        if (this.isZipComplete(child)) {
                            String path = this.relativeTo == null ? child.getAbsolutePath() : relativePath + fileName;
                            boolean archive = child.isFile();
                            this.addContentAddingTask(path, archive, fileName, child, timestamp, scanContext);
                            continue;
                        }
                        if (!child.exists()) continue;
                        scanContext.incompleteFiles.put(child, new IncompleteDeploymentStatus(child, timestamp));
                    }
                    catch (ZipCompletionScanner.NonScannableZipException e) {
                        scanContext.nonscannable.put(child, new NonScannableStatus(e, timestamp));
                    }
                    continue;
                }
                if (this.deployed.containsKey(fileName) || new File(fileName + DO_DEPLOY).exists() || new File(fileName + FAILED_DEPLOY).exists()) continue;
                scanContext.nonDeployable.add(fileName);
                continue;
            }
            if (this.isXmlFile(fileName)) {
                if (this.autoDeployXml) {
                    DeploymentMarker marker;
                    long timestamp;
                    if (this.isAutoDeployDisabled(child) || this.isFailedOrUndeployed(directory, fileName, timestamp = this.getDeploymentTimestamp(child)) || (marker = this.deployed.get(fileName)) != null && marker.lastModified == timestamp) continue;
                    if (this.isXmlComplete(child)) {
                        String path = this.relativeTo == null ? child.getAbsolutePath() : relativePath + fileName;
                        this.addContentAddingTask(path, true, fileName, child, timestamp, scanContext);
                        continue;
                    }
                    if (!child.exists()) continue;
                    scanContext.incompleteFiles.put(child, new IncompleteDeploymentStatus(child, timestamp));
                    continue;
                }
                if (this.deployed.containsKey(fileName) || new File(fileName + DO_DEPLOY).exists() || new File(fileName + FAILED_DEPLOY).exists()) continue;
                scanContext.nonDeployable.add(fileName);
                continue;
            }
            if (fileName.endsWith(DEPLOYING) || fileName.endsWith(UNDEPLOYING)) {
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (fileName.endsWith(PENDING)) {
                String deploymentName = fileName.substring(0, fileName.length() - PENDING.length());
                File deployment = new File(child.getParent(), deploymentName);
                if (deployment.exists()) continue;
                this.removeExtraneousMarker(child, fileName);
                continue;
            }
            if (!child.isDirectory()) continue;
            if (WEB_INF.equalsIgnoreCase(fileName) || META_INF.equalsIgnoreCase(fileName)) {
                scanContext.illegalDir.add(fileName);
                continue;
            }
            this.scanDirectory(child, relativePath + child.getName() + File.separator, scanContext);
        }
    }

    private boolean isXmlComplete(File xmlFile) {
        try {
            return XmlCompletionScanner.isCompleteDocument(xmlFile);
        }
        catch (Exception e) {
            DeploymentScannerLogger.ROOT_LOGGER.failedCheckingXMLFile(e, xmlFile.getPath());
            return false;
        }
    }

    private boolean isFailedOrUndeployed(File directory, String fileName, long timestamp) {
        File failedMarker = new File(directory, fileName + FAILED_DEPLOY);
        if (failedMarker.exists() && timestamp <= failedMarker.lastModified()) {
            return true;
        }
        File undeployedMarker = new File(directory, fileName + UNDEPLOYED);
        return undeployedMarker.exists() && timestamp <= undeployedMarker.lastModified();
    }

    private long addContentAddingTask(String path, boolean archive, String deploymentName, File deploymentFile, long timestamp, ScanContext scanContext) {
        if (scanContext.registeredDeployments.contains(deploymentName)) {
            scanContext.scannerTasks.add(new ReplaceTask(path, archive, deploymentName, deploymentFile, timestamp));
        } else {
            scanContext.scannerTasks.add(new DeployTask(path, archive, deploymentName, deploymentFile, timestamp));
        }
        scanContext.toRemove.remove(deploymentName);
        return timestamp;
    }

    private boolean isZipComplete(File file) throws ZipCompletionScanner.NonScannableZipException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (this.isZipComplete(child)) continue;
                return false;
            }
            return true;
        }
        if (this.isEEArchive(file.getName())) {
            try {
                return ZipCompletionScanner.isCompleteZip(file);
            }
            catch (IOException e) {
                DeploymentScannerLogger.ROOT_LOGGER.failedCheckingZipFile(e, file.getPath());
                return false;
            }
        }
        return true;
    }

    private boolean isAutoDeployDisabled(File file) {
        String name;
        File parent = file.getParentFile();
        return new File(parent, (name = file.getName()) + SKIP_DEPLOY).exists() || new File(parent, name + DO_DEPLOY).exists();
    }

    private long getDeploymentTimestamp(File deploymentFile) {
        if (deploymentFile.isDirectory()) {
            long latest = deploymentFile.lastModified();
            for (File child : deploymentFile.listFiles()) {
                long childTimestamp = this.getDeploymentTimestamp(child);
                if (childTimestamp <= latest) continue;
                latest = childTimestamp;
            }
            return latest;
        }
        return deploymentFile.lastModified();
    }

    private boolean isEEArchive(String fileName) {
        return ARCHIVE_PATTERN.matcher(fileName).matches();
    }

    private boolean isXmlFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    private void removeExtraneousMarker(File child, String fileName) {
        if (!child.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(fileName);
        }
    }

    private ScanStatus handleAutoDeployFailures(ScanContext scanContext) {
        ScanStatus result = ScanStatus.PROCEED;
        boolean warnLogged = false;
        HashSet<File> noLongerIncomplete = new HashSet<File>(this.incompleteDeployments.keySet());
        noLongerIncomplete.removeAll(scanContext.incompleteFiles.keySet());
        int oldIncompleteCount = this.incompleteDeployments.size();
        this.incompleteDeployments.keySet().retainAll(scanContext.incompleteFiles.keySet());
        if (scanContext.incompleteFiles.size() > 0) {
            result = ScanStatus.RETRY;
            boolean logAll = this.incompleteDeployments.size() != oldIncompleteCount;
            long now = System.currentTimeMillis();
            for (Map.Entry entry : scanContext.incompleteFiles.entrySet()) {
                boolean newIncomplete;
                File incompleteFile = (File)entry.getKey();
                String deploymentName = incompleteFile.getName();
                IncompleteDeploymentStatus status = this.incompleteDeployments.get(incompleteFile);
                if (status == null || status.size < ((IncompleteDeploymentStatus)entry.getValue()).size) {
                    status = (IncompleteDeploymentStatus)entry.getValue();
                }
                if (now - status.timestamp > this.maxNoProgress) {
                    if (!status.warned) {
                        String suffix = this.deployed.containsKey(deploymentName) ? DeploymentScannerMessages.MESSAGES.previousContentDeployed() : "";
                        String msg = DeploymentScannerMessages.MESSAGES.deploymentContentIncomplete(incompleteFile, suffix);
                        this.writeFailedMarker(incompleteFile, new ModelNode().set(msg), status.timestamp);
                        DeploymentScannerLogger.ROOT_LOGGER.error(msg);
                        status.warned = true;
                        warnLogged = true;
                        result = ScanStatus.ABORT;
                    }
                    new File(incompleteFile.getParentFile(), deploymentName + PENDING).delete();
                    continue;
                }
                boolean bl = newIncomplete = this.incompleteDeployments.put(incompleteFile, status) == null;
                if (newIncomplete || logAll) {
                    DeploymentScannerLogger.ROOT_LOGGER.incompleteContent(((File)entry.getKey()).getPath());
                }
                if (!newIncomplete) continue;
                File pending = new File(incompleteFile.getParentFile(), deploymentName + PENDING);
                this.createMarkerFile(pending, deploymentName);
            }
        }
        for (File complete : noLongerIncomplete) {
            File pending = new File(complete.getParentFile(), complete.getName() + PENDING);
            this.removeExtraneousMarker(pending, pending.getName());
        }
        int oldNonScannableCount = this.nonscannableLogged.size();
        this.nonscannableLogged.retainAll(scanContext.nonscannable.keySet());
        if (scanContext.nonscannable.size() > 0) {
            result = result == ScanStatus.PROCEED ? ScanStatus.RETRY : result;
            boolean logAll = this.nonscannableLogged.size() != oldNonScannableCount;
            for (Map.Entry entry : scanContext.nonscannable.entrySet()) {
                File nonScannable = (File)entry.getKey();
                String fileName = nonScannable.getName();
                if (!this.nonscannableLogged.add(nonScannable) && !logAll) continue;
                NonScannableStatus nonScannableStatus = (NonScannableStatus)entry.getValue();
                ZipCompletionScanner.NonScannableZipException e = nonScannableStatus.exception;
                String msg = DeploymentScannerMessages.MESSAGES.unsafeAutoDeploy(e.getLocalizedMessage(), fileName, DO_DEPLOY);
                this.writeFailedMarker(nonScannable, new ModelNode().set(msg), nonScannableStatus.timestamp);
                DeploymentScannerLogger.ROOT_LOGGER.error(msg);
                warnLogged = true;
                result = ScanStatus.ABORT;
            }
        }
        if (warnLogged) {
            HashSet<String> allProblems = new HashSet<String>();
            for (File file : scanContext.nonscannable.keySet()) {
                allProblems.add(file.getName());
            }
            for (File file : scanContext.incompleteFiles.keySet()) {
                allProblems.add(file.getName());
            }
            DeploymentScannerLogger.ROOT_LOGGER.unsafeAutoDeploy(DO_DEPLOY, SKIP_DEPLOY, allProblems);
        }
        return result;
    }

    private synchronized void startScan() {
        if (this.scanEnabled) {
            this.scanTask = this.scanInterval > 0L ? this.scheduledExecutor.scheduleWithFixedDelay(this.scanRunnable, 0L, this.scanInterval, TimeUnit.MILLISECONDS) : this.scheduledExecutor.schedule(this.scanRunnable, this.scanInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelScan() {
        if (this.rescanIncompleteTask != null) {
            this.rescanIncompleteTask.cancel(false);
            this.rescanIncompleteTask = null;
        }
        if (this.scanTask != null) {
            this.scanTask.cancel(false);
            this.scanTask = null;
        }
    }

    private Set<String> getDeploymentNames() throws CancellationException {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-names", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.controllerClient.execute(op);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelNode result = response.get("result");
        HashSet<String> deploymentNames = new HashSet<String>();
        if (result.isDefined()) {
            List deploymentNodes = result.asList();
            for (ModelNode node : deploymentNodes) {
                deploymentNames.add(node.asString());
            }
        }
        return deploymentNames;
    }

    private ModelNode getCompositeUpdate(List<ModelNode> updates) {
        ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = op.get("steps");
        for (ModelNode update : updates) {
            steps.add(update);
        }
        return op;
    }

    private ModelNode getCompositeUpdate(ModelNode ... updates) {
        ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = op.get("steps");
        for (ModelNode update : updates) {
            steps.add(update);
        }
        return op;
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMarkerFile(File marker, String deploymentName) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(marker);
            fos.write(deploymentName.getBytes());
        }
        catch (IOException io) {
            DeploymentScannerLogger.ROOT_LOGGER.errorWritingDeploymentMarker(io, marker.getAbsolutePath());
        }
        finally {
            this.safeClose(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFailedMarker(File deploymentFile, ModelNode failureDescription, long failureTimestamp) {
        File undeployedMarker;
        File deployedMarker;
        File failedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + FAILED_DEPLOY);
        File deployMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + DO_DEPLOY);
        if (deployMarker.exists() && !deployMarker.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(deployMarker);
        }
        if ((deployedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + DEPLOYED)).exists() && !deployedMarker.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(deployedMarker);
        }
        if ((undeployedMarker = new File(deploymentFile.getParent(), deploymentFile.getName() + UNDEPLOYED)).exists() && !undeployedMarker.delete()) {
            DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(undeployedMarker);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(failedMarker);
            fos.write(failureDescription.asString().getBytes());
        }
        catch (IOException io) {
            DeploymentScannerLogger.ROOT_LOGGER.errorWritingDeploymentMarker(io, failedMarker.getAbsolutePath());
        }
        finally {
            this.safeClose(fos);
        }
    }

    private class DeploymentTask
    implements Callable<ModelNode> {
        private final Operation deploymentOp;

        private DeploymentTask(Operation deploymentOp) {
            this.deploymentOp = deploymentOp;
        }

        @Override
        public ModelNode call() {
            try {
                return FileSystemDeploymentService.this.controllerClient.execute(this.deploymentOp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum ScanStatus {
        ABORT,
        RETRY,
        PROCEED;

    }

    private static class NonScannableStatus {
        private final long timestamp;
        private final ZipCompletionScanner.NonScannableZipException exception;

        public NonScannableStatus(ZipCompletionScanner.NonScannableZipException exception, long timestamp) {
            this.exception = exception;
            this.timestamp = timestamp;
        }
    }

    private static class IncompleteDeploymentStatus {
        private final long timestamp;
        private final long size;
        private boolean warned;

        IncompleteDeploymentStatus(File file, long timestamp) {
            this.size = file.length();
            this.timestamp = timestamp;
        }
    }

    private class ScanContext {
        private final Set<String> registeredDeployments;
        private final List<ScannerTask> scannerTasks;
        private final Set<String> toRemove;
        private final HashSet<String> ignoredMissingDeployments;
        private Map<File, IncompleteDeploymentStatus> incompleteFiles;
        private final HashSet<String> nonDeployable;
        private final HashSet<String> illegalDir;
        private final HashSet<String> prematureExplodedDeletions;
        private final Map<File, NonScannableStatus> nonscannable;
        private final long scanStartTime;

        private ScanContext() {
            this.registeredDeployments = FileSystemDeploymentService.this.getDeploymentNames();
            this.scannerTasks = new ArrayList<ScannerTask>();
            this.toRemove = new HashSet(FileSystemDeploymentService.this.deployed.keySet());
            this.ignoredMissingDeployments = new HashSet();
            this.incompleteFiles = new HashMap<File, IncompleteDeploymentStatus>();
            this.nonDeployable = new HashSet();
            this.illegalDir = new HashSet();
            this.prematureExplodedDeletions = new HashSet();
            this.nonscannable = new HashMap<File, NonScannableStatus>();
            this.scanStartTime = System.currentTimeMillis();
        }
    }

    private class DeploymentMarker {
        private final long lastModified;
        private boolean archive;

        private DeploymentMarker(long lastModified, boolean archive) {
            this.lastModified = lastModified;
            this.archive = archive;
        }
    }

    private final class UndeployTask
    extends ScannerTask {
        private final long scanStartTime;

        private UndeployTask(String deploymentName, File parent, long scanStartTime) {
            super(deploymentName, parent, FileSystemDeploymentService.UNDEPLOYING);
            this.scanStartTime = scanStartTime;
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            ModelNode undeployOp = Util.getEmptyOperation((String)"undeploy", (ModelNode)address);
            ModelNode removeOp = Util.getEmptyOperation((String)"remove", (ModelNode)address);
            return FileSystemDeploymentService.this.getCompositeUpdate(new ModelNode[]{undeployOp, removeOp});
        }

        @Override
        protected void handleSuccessResult() {
            this.removeInProgressMarker();
            this.deleteDeployedMarker();
            File undeployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.UNDEPLOYED);
            FileSystemDeploymentService.this.createMarkerFile(undeployedMarker, this.deploymentName);
            undeployedMarker.setLastModified(this.scanStartTime);
            FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            FileSystemDeploymentService.this.noticeLogged.remove(this.deploymentName);
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(new File(this.parent, this.deploymentName), result.get("failure-description"), this.scanStartTime);
        }
    }

    private final class RedeployTask
    extends ScannerTask {
        private final long markerLastModified;
        private final boolean archive;

        private RedeployTask(String deploymentName, long markerLastModified, File parent, boolean archive) {
            super(deploymentName, parent, FileSystemDeploymentService.DEPLOYING);
            this.markerLastModified = markerLastModified;
            this.archive = archive;
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            return Util.getEmptyOperation((String)"redeploy", (ModelNode)address);
        }

        @Override
        protected void handleSuccessResult() {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            FileSystemDeploymentService.this.deployed.put(this.deploymentName, new DeploymentMarker(this.markerLastModified, this.archive));
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(new File(this.parent, this.deploymentName), result.get("failure-description"), this.markerLastModified);
        }
    }

    private final class ReplaceTask
    extends ContentAddingTask {
        private ReplaceTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(path, archive, deploymentName, deploymentFile, markerTimestamp);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode replaceOp = Util.getEmptyOperation((String)"full-replace-deployment", (ModelNode)new ModelNode());
            replaceOp.get("name").set(this.deploymentName);
            replaceOp.get("content").set(this.createContent());
            return replaceOp;
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(this.deploymentFile, result.get("failure-description"), this.doDeployTimestamp);
        }
    }

    private final class DeployTask
    extends ContentAddingTask {
        private DeployTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(path, archive, deploymentName, deploymentFile, markerTimestamp);
        }

        @Override
        protected ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", this.deploymentName);
            ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
            addOp.get("content").set(this.createContent());
            addOp.get("persistent").set(false);
            ModelNode deployOp = Util.getEmptyOperation((String)"deploy", (ModelNode)address);
            return FileSystemDeploymentService.this.getCompositeUpdate(new ModelNode[]{addOp, deployOp});
        }

        @Override
        protected void handleFailureResult(ModelNode result) {
            DeploymentScannerLogger.ROOT_LOGGER.error(result.get("failure-description").asString());
            this.removeInProgressMarker();
            FileSystemDeploymentService.this.writeFailedMarker(this.deploymentFile, result.get("failure-description"), this.doDeployTimestamp);
        }
    }

    private abstract class ContentAddingTask
    extends ScannerTask {
        private final String path;
        private final boolean archive;
        protected final File deploymentFile;
        protected final long doDeployTimestamp;

        protected ContentAddingTask(String path, boolean archive, String deploymentName, File deploymentFile, long markerTimestamp) {
            super(deploymentName, deploymentFile.getParentFile(), FileSystemDeploymentService.DEPLOYING);
            this.path = path;
            this.archive = archive;
            this.deploymentFile = deploymentFile;
            this.doDeployTimestamp = markerTimestamp;
        }

        protected ModelNode createContent() {
            ModelNode content = new ModelNode();
            ModelNode contentItem = content.get(0);
            contentItem.get("path").set(this.path);
            if (FileSystemDeploymentService.this.relativeTo != null) {
                contentItem.get("relative-to").set(FileSystemDeploymentService.this.relativeTo);
            }
            contentItem.get("archive").set(this.archive);
            return content;
        }

        @Override
        protected void handleSuccessResult() {
            File failedMarker;
            File doDeployMarker = new File(new File(this.parent), this.deploymentFile.getName() + FileSystemDeploymentService.DO_DEPLOY);
            if (doDeployMarker.exists() && !doDeployMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(doDeployMarker.getAbsolutePath());
            }
            if ((failedMarker = new File(this.deploymentFile.getParent(), this.deploymentFile.getName() + FileSystemDeploymentService.FAILED_DEPLOY)).exists() && !failedMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(failedMarker);
            }
            File deployedMarker = new File(this.parent, this.deploymentFile.getName() + FileSystemDeploymentService.DEPLOYED);
            FileSystemDeploymentService.this.createMarkerFile(deployedMarker, this.deploymentName);
            deployedMarker.setLastModified(this.doDeployTimestamp);
            if (FileSystemDeploymentService.this.deployed.containsKey(this.deploymentName)) {
                FileSystemDeploymentService.this.deployed.remove(this.deploymentName);
            }
            FileSystemDeploymentService.this.deployed.put(this.deploymentName, new DeploymentMarker(this.doDeployTimestamp, this.archive));
            this.removeInProgressMarker();
        }
    }

    private abstract class ScannerTask {
        protected final String deploymentName;
        protected final String parent;
        private final String inProgressMarkerSuffix;

        private ScannerTask(String deploymentName, File parent, String inProgressMarkerSuffix) {
            this.deploymentName = deploymentName;
            this.parent = parent.getAbsolutePath();
            this.inProgressMarkerSuffix = inProgressMarkerSuffix;
            File marker = new File(parent, deploymentName + FileSystemDeploymentService.PENDING);
            if (!marker.exists()) {
                FileSystemDeploymentService.this.createMarkerFile(marker, deploymentName);
            }
        }

        protected void recordInProgress() {
            File marker = new File(this.parent, this.deploymentName + this.inProgressMarkerSuffix);
            FileSystemDeploymentService.this.createMarkerFile(marker, this.deploymentName);
            this.deleteUndeployedMarker();
            this.deletePendingMarker();
        }

        protected abstract ModelNode getUpdate();

        protected abstract void handleSuccessResult();

        protected abstract void handleFailureResult(ModelNode var1);

        protected void deletePendingMarker() {
            File pendingMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.PENDING);
            if (pendingMarker.exists() && !pendingMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(pendingMarker);
            }
        }

        protected void deleteUndeployedMarker() {
            File undeployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.UNDEPLOYED);
            if (undeployedMarker.exists() && !undeployedMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(undeployedMarker);
            }
        }

        protected void deleteDeployedMarker() {
            File deployedMarker = new File(this.parent, this.deploymentName + FileSystemDeploymentService.DEPLOYED);
            if (deployedMarker.exists() && !deployedMarker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotRemoveDeploymentMarker(deployedMarker);
            }
        }

        protected void removeInProgressMarker() {
            File marker = new File(new File(this.parent), this.deploymentName + this.inProgressMarkerSuffix);
            if (marker.exists() && !marker.delete()) {
                DeploymentScannerLogger.ROOT_LOGGER.cannotDeleteDeploymentProgressMarker(marker);
            }
        }
    }

    private class DeploymentScanRunnable
    implements Runnable {
        private DeploymentScanRunnable() {
        }

        @Override
        public void run() {
            try {
                FileSystemDeploymentService.this.scan();
            }
            catch (Exception e) {
                DeploymentScannerLogger.ROOT_LOGGER.scanException(e, FileSystemDeploymentService.this.deploymentDir.getAbsolutePath());
            }
        }
    }
}

