/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.crsh.Processor;
import org.crsh.ProcessorListener;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.shell.concurrent.AsyncShell;
import org.crsh.shell.impl.CRaSH;
import org.crsh.term.BaseTerm;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TermIOHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorIOHandler
extends CRaSHPlugin<TermIOHandler>
implements TermIOHandler {
    private ExecutorService executor;

    @Override
    public TermIOHandler getImplementation() {
        return this;
    }

    @Override
    public void init() {
        this.executor = Executors.newFixedThreadPool(3);
    }

    @Override
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void handle(final TermIO io) {
        final CRaSH shell = new CRaSH(this.getContext());
        final AsyncShell asyncShell = new AsyncShell(this.executor, shell);
        BaseTerm term = new BaseTerm(io);
        Processor processor = new Processor(term, asyncShell);
        processor.addListener(new ProcessorListener(){

            public void closed() {
                io.close();
            }
        });
        processor.addListener(new ProcessorListener(){

            public void closed() {
                asyncShell.close();
            }
        });
        processor.addListener(new ProcessorListener(){

            public void closed() {
                shell.close();
            }
        });
        processor.run();
    }
}

