/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.repository.ArtifactProviderPlugin;
import org.jboss.osgi.repository.RepositoryCachePlugin;
import org.jboss.osgi.repository.core.FileBasedRepositoryCachePlugin;
import org.jboss.osgi.repository.core.MavenArtifactProvider;
import org.jboss.osgi.repository.core.RepositoryImpl;
import org.jboss.osgi.repository.core.TrackingArtifactProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.repository.Repository;

final class RepositoryProvider
extends AbstractService<Repository> {
    public static final ServiceName SERVICE_NAME = FrameworkBootstrapService.SERVICE_BASE_NAME.append(new String[]{"repository.provider"});
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private Repository repository;

    static ServiceController<?> addService(ServiceTarget target) {
        RepositoryProvider service = new RepositoryProvider();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        return builder.install();
    }

    private RepositoryProvider() {
    }

    public void start(StartContext context) throws StartException {
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        MavenArtifactProvider provider = new MavenArtifactProvider();
        syscontext.registerService(ArtifactProviderPlugin.class.getName(), (Object)provider, null);
        File cacheFile = syscontext.getDataFile("repository");
        FileBasedRepositoryCachePlugin cache = new FileBasedRepositoryCachePlugin(cacheFile);
        this.repository = new RepositoryImpl((ArtifactProviderPlugin)new TrackingArtifactProvider(syscontext), (RepositoryCachePlugin)cache);
        syscontext.registerService(Repository.class.getName(), (Object)this.repository, null);
    }

    public Repository getValue() throws IllegalStateException {
        return this.repository;
    }

    public String toString() {
        return RepositoryProvider.class.getSimpleName();
    }
}

