/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static final long serialVersionUID = -1934618396111902255L;
    private static HashMap cCache;
    private final DateTimeFieldType iType;
    private final DurationField iDurationField;

    public static synchronized UnsupportedDateTimeField getInstance(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        UnsupportedDateTimeField unsupportedDateTimeField;
        if (cCache == null) {
            cCache = new HashMap(7);
            unsupportedDateTimeField = null;
        } else {
            unsupportedDateTimeField = (UnsupportedDateTimeField)cCache.get(dateTimeFieldType);
            if (unsupportedDateTimeField != null && unsupportedDateTimeField.getDurationField() != durationField) {
                unsupportedDateTimeField = null;
            }
        }
        if (unsupportedDateTimeField == null) {
            unsupportedDateTimeField = new UnsupportedDateTimeField(dateTimeFieldType, durationField);
            cCache.put(dateTimeFieldType, unsupportedDateTimeField);
        }
        return unsupportedDateTimeField;
    }

    private UnsupportedDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        if (dateTimeFieldType == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = dateTimeFieldType;
        this.iDurationField = durationField;
    }

    @Override
    public DateTimeFieldType getType() {
        return this.iType;
    }

    @Override
    public String getName() {
        return this.iType.getName();
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public int get(long l) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(long l, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(long l) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(ReadablePartial readablePartial, int n, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(ReadablePartial readablePartial, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsText(int n, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(long l, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(long l) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(ReadablePartial readablePartial, int n, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(ReadablePartial readablePartial, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public String getAsShortText(int n, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public long add(long l, int n) {
        return this.getDurationField().add(l, n);
    }

    @Override
    public long add(long l, long l2) {
        return this.getDurationField().add(l, l2);
    }

    @Override
    public int[] add(ReadablePartial readablePartial, int n, int[] nArray, int n2) {
        throw this.unsupported();
    }

    @Override
    public int[] addWrapPartial(ReadablePartial readablePartial, int n, int[] nArray, int n2) {
        throw this.unsupported();
    }

    @Override
    public long addWrapField(long l, int n) {
        throw this.unsupported();
    }

    @Override
    public int[] addWrapField(ReadablePartial readablePartial, int n, int[] nArray, int n2) {
        throw this.unsupported();
    }

    @Override
    public int getDifference(long l, long l2) {
        return this.getDurationField().getDifference(l, l2);
    }

    @Override
    public long getDifferenceAsLong(long l, long l2) {
        return this.getDurationField().getDifferenceAsLong(l, l2);
    }

    @Override
    public long set(long l, int n) {
        throw this.unsupported();
    }

    @Override
    public int[] set(ReadablePartial readablePartial, int n, int[] nArray, int n2) {
        throw this.unsupported();
    }

    @Override
    public long set(long l, String string, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public long set(long l, String string) {
        throw this.unsupported();
    }

    @Override
    public int[] set(ReadablePartial readablePartial, int n, int[] nArray, String string, Locale locale) {
        throw this.unsupported();
    }

    @Override
    public DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public boolean isLeap(long l) {
        throw this.unsupported();
    }

    @Override
    public int getLeapAmount(long l) {
        throw this.unsupported();
    }

    @Override
    public DurationField getLeapDurationField() {
        return null;
    }

    @Override
    public int getMinimumValue() {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(long l) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(ReadablePartial readablePartial) {
        throw this.unsupported();
    }

    @Override
    public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue() {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(long l) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        throw this.unsupported();
    }

    @Override
    public long roundFloor(long l) {
        throw this.unsupported();
    }

    @Override
    public long roundCeiling(long l) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfFloor(long l) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfCeiling(long l) {
        throw this.unsupported();
    }

    @Override
    public long roundHalfEven(long l) {
        throw this.unsupported();
    }

    @Override
    public long remainder(long l) {
        throw this.unsupported();
    }

    @Override
    public String toString() {
        return "UnsupportedDateTimeField";
    }

    private Object readResolve() {
        return UnsupportedDateTimeField.getInstance(this.iType, this.iDurationField);
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }
}

