/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementHelper {
    private static final Logger log = Logger.getLogger(ManagementHelper.class);
    public static final SimpleString HDR_RESOURCE_NAME = new SimpleString("_HQ_ResourceName");
    public static final SimpleString HDR_ATTRIBUTE = new SimpleString("_HQ_Attribute");
    public static final SimpleString HDR_OPERATION_NAME = new SimpleString("_HQ_OperationName");
    public static final SimpleString HDR_OPERATION_SUCCEEDED = new SimpleString("_HQ_OperationSucceeded");
    public static final SimpleString HDR_NOTIFICATION_TYPE = new SimpleString("_HQ_NotifType");
    public static final SimpleString HDR_NOTIFICATION_TIMESTAMP = new SimpleString("_HQ_NotifTimestamp");
    public static final SimpleString HDR_ROUTING_NAME = new SimpleString("_HQ_RoutingName");
    public static final SimpleString HDR_CLUSTER_NAME = new SimpleString("_HQ_ClusterName");
    public static final SimpleString HDR_ADDRESS = new SimpleString("_HQ_Address");
    public static final SimpleString HDR_BINDING_ID = new SimpleString("_HQ_Binding_ID");
    public static final SimpleString HDR_BINDING_TYPE = new SimpleString("_HQ_Binding_Type");
    public static final SimpleString HDR_FILTERSTRING = new SimpleString("_HQ_FilterString");
    public static final SimpleString HDR_DISTANCE = new SimpleString("_HQ_Distance");
    public static final SimpleString HDR_CONSUMER_COUNT = new SimpleString("_HQ_ConsumerCount");
    public static final SimpleString HDR_USER = new SimpleString("_HQ_User");
    public static final SimpleString HDR_CHECK_TYPE = new SimpleString("_HQ_CheckType");
    public static final SimpleString HDR_SESSION_NAME = new SimpleString("_HQ_SessionName");
    public static final SimpleString HDR_REMOTE_ADDRESS = new SimpleString("_HQ_RemoteAddress");
    public static final SimpleString HDR_PROPOSAL_GROUP_ID = new SimpleString("_JBM_ProposalGroupId");
    public static final SimpleString HDR_PROPOSAL_VALUE = new SimpleString("_JBM_ProposalValue");
    public static final SimpleString HDR_PROPOSAL_ALT_VALUE = new SimpleString("_JBM_ProposalAltValue");

    public static void putAttribute(Message message, String resourceName, String attribute) {
        message.putStringProperty(HDR_RESOURCE_NAME, new SimpleString(resourceName));
        message.putStringProperty(HDR_ATTRIBUTE, new SimpleString(attribute));
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName) throws Exception {
        ManagementHelper.putOperationInvocation(message, resourceName, operationName, null);
    }

    public static void putOperationInvocation(Message message, String resourceName, String operationName, Object ... parameters) throws Exception {
        String paramString;
        message.putStringProperty(HDR_RESOURCE_NAME, new SimpleString(resourceName));
        message.putStringProperty(HDR_OPERATION_NAME, new SimpleString(operationName));
        if (parameters != null) {
            JSONArray jsonArray = ManagementHelper.toJSONArray(parameters);
            paramString = jsonArray.toString();
        } else {
            paramString = null;
        }
        message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString(paramString));
    }

    private static JSONArray toJSONArray(Object[] array) throws Exception {
        JSONArray jsonArray = new JSONArray();
        for (Object parameter : array) {
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                JSONObject jsonObject = new JSONObject();
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (val != null) {
                        if (val.getClass().isArray()) {
                            val = ManagementHelper.toJSONArray((Object[])val);
                        } else {
                            ManagementHelper.checkType(val);
                        }
                    }
                    jsonObject.put(key, val);
                }
                jsonArray.put(jsonObject);
                continue;
            }
            if (parameter != null) {
                Class<?> clz = parameter.getClass();
                if (clz.isArray()) {
                    Object[] innerArray = (Object[])parameter;
                    jsonArray.put(ManagementHelper.toJSONArray(innerArray));
                    continue;
                }
                ManagementHelper.checkType(parameter);
                jsonArray.put(parameter);
                continue;
            }
            jsonArray.put((Object)null);
        }
        return jsonArray;
    }

    private static Object[] fromJSONArray(JSONArray jsonArray) throws Exception {
        Object[] array = new Object[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object val = jsonArray.get(i);
            if (val instanceof JSONArray) {
                Object[] inner;
                array[i] = inner = ManagementHelper.fromJSONArray((JSONArray)val);
                continue;
            }
            if (val instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)val;
                HashMap<String, Object[]> map = new HashMap<String, Object[]>();
                Iterator iter = jsonObject.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object innerVal = jsonObject.get(key);
                    if (innerVal instanceof JSONArray) {
                        innerVal = ManagementHelper.fromJSONArray((JSONArray)innerVal);
                    } else if (innerVal instanceof JSONObject) {
                        HashMap<String, Object> innerMap = new HashMap<String, Object>();
                        JSONObject o = (JSONObject)innerVal;
                        Iterator it = o.keys();
                        while (it.hasNext()) {
                            String k = (String)it.next();
                            innerMap.put(k, o.get(k));
                        }
                        innerVal = innerMap;
                    } else if (innerVal instanceof Integer) {
                        innerVal = ((Integer)innerVal).longValue();
                    }
                    map.put(key, (Object[])innerVal);
                }
                array[i] = map;
                continue;
            }
            array[i] = val == JSONObject.NULL ? null : val;
        }
        return array;
    }

    private static void checkType(Object param) {
        if (!(param instanceof Integer || param instanceof Long || param instanceof Double || param instanceof String || param instanceof Boolean || param instanceof Map || param instanceof Byte || param instanceof Short)) {
            throw new IllegalArgumentException("Params for management operations must be of the following type: int long double String boolean Map or array thereof  but found " + param.getClass().getName());
        }
    }

    public static Object[] retrieveOperationParameters(Message message) throws Exception {
        String jsonString;
        SimpleString sstring = message.getBodyBuffer().readNullableSimpleString();
        String string = jsonString = sstring == null ? null : sstring.toString();
        if (jsonString != null) {
            JSONArray jsonArray = new JSONArray(jsonString);
            return ManagementHelper.fromJSONArray(jsonArray);
        }
        return null;
    }

    public static boolean isOperationResult(Message message) {
        return message.containsProperty(HDR_OPERATION_SUCCEEDED);
    }

    public static boolean isAttributesResult(Message message) {
        return !ManagementHelper.isOperationResult(message);
    }

    public static void storeResult(Message message, Object result) throws Exception {
        String resultString;
        if (result != null) {
            JSONArray jsonArray = ManagementHelper.toJSONArray(new Object[]{result});
            resultString = jsonArray.toString();
        } else {
            resultString = null;
        }
        message.getBodyBuffer().writeNullableSimpleString(SimpleString.toSimpleString(resultString));
    }

    public static Object[] getResults(Message message) throws Exception {
        String jsonString;
        SimpleString sstring = message.getBodyBuffer().readNullableSimpleString();
        String string = jsonString = sstring == null ? null : sstring.toString();
        if (jsonString != null) {
            JSONArray jsonArray = new JSONArray(jsonString);
            Object[] res = ManagementHelper.fromJSONArray(jsonArray);
            return res;
        }
        return null;
    }

    public static Object getResult(Message message) throws Exception {
        Object[] res = ManagementHelper.getResults(message);
        if (res != null) {
            return res[0];
        }
        return null;
    }

    public static boolean hasOperationSucceeded(Message message) {
        if (!ManagementHelper.isOperationResult(message)) {
            return false;
        }
        if (message.containsProperty(HDR_OPERATION_SUCCEEDED)) {
            return message.getBooleanProperty(HDR_OPERATION_SUCCEEDED);
        }
        return false;
    }

    public static Map<String, Object> fromCommaSeparatedKeyValues(String str) throws Exception {
        if (str == null || str.trim().length() == 0) {
            return Collections.emptyMap();
        }
        JSONArray array = new JSONArray("[{" + str + "}]");
        Map params = (Map)ManagementHelper.fromJSONArray(array)[0];
        return params;
    }

    public static Object[] fromCommaSeparatedArrayOfCommaSeparatedKeyValues(String str) throws Exception {
        if (str == null || str.trim().length() == 0) {
            return new Object[0];
        }
        String s = str;
        if (!s.trim().startsWith("{")) {
            s = "{" + s + "}";
        }
        JSONArray array = new JSONArray("[" + s + "]");
        return ManagementHelper.fromJSONArray(array);
    }

    private ManagementHelper() {
    }
}

