/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.remoting3.MessageInputStream;

class TransactionInvocationResponseHandler
extends ProtocolMessageHandler {
    private final ChannelAssociation channelAssociation;

    TransactionInvocationResponseHandler(ChannelAssociation channelAssociation) {
        this.channelAssociation = channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(messageInputStream);
        try {
            short invocationId = dataInputStream.readShort();
            boolean prepareTx = dataInputStream.readBoolean();
            if (prepareTx) {
                int prepareInvocationResult = PackedInteger.readPackedInteger(dataInputStream);
                this.channelAssociation.resultReady(invocationId, new TxInvocationResultProducer(prepareInvocationResult));
            } else {
                this.channelAssociation.resultReady(invocationId, new TxInvocationResultProducer());
            }
        }
        finally {
            dataInputStream.close();
        }
    }

    private class TxInvocationResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private Integer txResult;

        TxInvocationResultProducer() {
            this.txResult = null;
        }

        TxInvocationResultProducer(Integer txResult) {
            this.txResult = txResult;
        }

        @Override
        public Object getResult() throws Exception {
            return this.txResult;
        }

        @Override
        public void discardResult() {
        }
    }
}

