/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.UnreplayableOperationException;

class ReplayingDecoderBuffer
implements ChannelBuffer {
    private static final Error REPLAY = new ReplayError();
    private final ChannelBuffer buffer;
    private boolean terminated;

    ReplayingDecoderBuffer(ChannelBuffer buffer) {
        this.buffer = buffer;
    }

    void terminate() {
        this.terminated = true;
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnreplayableOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(ChannelBuffer buffer) {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer copy() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(index, length);
    }

    @Override
    public void discardReadBytes() {
        throw new UnreplayableOperationException();
    }

    @Override
    public void ensureWritableBytes(int writableBytes) {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer duplicate() {
        throw new UnreplayableOperationException();
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.buffer.getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        this.checkIndex(index);
        return this.buffer.getUnsignedByte(index);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.checkIndex(index, dst.length);
        this.buffer.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getUnsignedInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(index);
    }

    @Override
    public int getMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getMedium(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getUnsignedShort(index);
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getChar(index);
    }

    @Override
    public float getFloat(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getDouble(index);
    }

    @Override
    public int hashCode() {
        throw new UnreplayableOperationException();
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        int endIndex = this.buffer.indexOf(fromIndex, toIndex, value);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        int endIndex = this.buffer.indexOf(fromIndex, toIndex, indexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return endIndex;
    }

    @Override
    public int bytesBefore(byte value) {
        int bytes = this.buffer.bytesBefore(value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        int bytes = this.buffer.bytesBefore(indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int length, byte value) {
        this.checkReadableBytes(length);
        int bytes = this.buffer.bytesBefore(length, value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int length, ChannelBufferIndexFinder indexFinder) {
        this.checkReadableBytes(length);
        int bytes = this.buffer.bytesBefore(length, indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int index, int length, byte value) {
        int bytes = this.buffer.bytesBefore(index, length, value);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public int bytesBefore(int index, int length, ChannelBufferIndexFinder indexFinder) {
        int bytes = this.buffer.bytesBefore(index, length, indexFinder);
        if (bytes < 0) {
            throw REPLAY;
        }
        return bytes;
    }

    @Override
    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    @Override
    public void markWriterIndex() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public boolean readable() {
        return this.terminated ? this.buffer.readable() : true;
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
        this.buffer.readBytes(dst);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.buffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(ChannelBuffer dst, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void readBytes(ChannelBuffer dst) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public ChannelBuffer readBytes(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.buffer.indexOf(this.buffer.readerIndex(), this.buffer.writerIndex(), endIndexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return this.buffer.readBytes(endIndex - this.buffer.readerIndex());
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer readBytes(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readBytes(length);
    }

    @Override
    @Deprecated
    public ChannelBuffer readSlice(ChannelBufferIndexFinder endIndexFinder) {
        int endIndex = this.buffer.indexOf(this.buffer.readerIndex(), this.buffer.writerIndex(), endIndexFinder);
        if (endIndex < 0) {
            throw REPLAY;
        }
        return this.buffer.readSlice(endIndex - this.buffer.readerIndex());
    }

    @Override
    public ChannelBuffer readSlice(int length) {
        this.checkReadableBytes(length);
        return this.buffer.readSlice(length);
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    @Override
    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    @Override
    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    @Override
    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    @Override
    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    @Override
    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    @Override
    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    @Override
    public void resetWriterIndex() {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setByte(int index, int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, byte[] src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setZero(int index, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setInt(int index, int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setLong(int index, long value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setMedium(int index, int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setShort(int index, int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setChar(int index, int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setFloat(int index, float value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void setDouble(int index, double value) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public int skipBytes(ChannelBufferIndexFinder firstIndexFinder) {
        int oldReaderIndex = this.buffer.readerIndex();
        int newReaderIndex = this.buffer.indexOf(oldReaderIndex, this.buffer.writerIndex(), firstIndexFinder);
        if (newReaderIndex < 0) {
            throw REPLAY;
        }
        this.buffer.readerIndex(newReaderIndex);
        return newReaderIndex - oldReaderIndex;
    }

    @Override
    public void skipBytes(int length) {
        this.checkReadableBytes(length);
        this.buffer.skipBytes(length);
    }

    @Override
    public ChannelBuffer slice() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ChannelBuffer slice(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.slice(index, length);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.toByteBuffer(index, length);
    }

    @Override
    public ByteBuffer[] toByteBuffers() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ByteBuffer[] toByteBuffers(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.toByteBuffers(index, length);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        this.checkIndex(index, length);
        return this.buffer.toString(index, length, charset);
    }

    @Override
    public String toString(Charset charsetName) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public String toString(int index, int length, String charsetName) {
        this.checkIndex(index, length);
        return this.buffer.toString(index, length, charsetName);
    }

    @Override
    @Deprecated
    public String toString(int index, int length, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        this.checkIndex(index, length);
        return this.buffer.toString(index, length, charsetName, terminatorFinder);
    }

    @Override
    @Deprecated
    public String toString(String charsetName) {
        throw new UnreplayableOperationException();
    }

    @Override
    @Deprecated
    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        throw new UnreplayableOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex() + ", " + "widx=" + this.writerIndex() + ')';
    }

    @Override
    public boolean writable() {
        return false;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public void writeByte(int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(byte[] src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ChannelBuffer src, int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeBytes(ChannelBuffer src) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeInt(int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeLong(long value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeMedium(int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeZero(int length) {
        throw new UnreplayableOperationException();
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public void writerIndex(int writerIndex) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeShort(int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeChar(int value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeFloat(float value) {
        throw new UnreplayableOperationException();
    }

    @Override
    public void writeDouble(double value) {
        throw new UnreplayableOperationException();
    }

    private void checkIndex(int index) {
        if (index > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkIndex(int index, int length) {
        if (index + length > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int readableBytes) {
        if (this.buffer.readableBytes() < readableBytes) {
            throw REPLAY;
        }
    }
}

