/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpCodecUtil;

public class QueryStringDecoder {
    private final Charset charset;
    private final String uri;
    private String path;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String uri) {
        this(uri, HttpCodecUtil.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(String uri, Charset charset) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.uri = uri;
        this.charset = charset;
    }

    @Deprecated
    public QueryStringDecoder(String uri, String charset) {
        this(uri, Charset.forName(charset));
    }

    public QueryStringDecoder(URI uri) {
        this(uri, HttpCodecUtil.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(URI uri, Charset charset) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.uri = uri.toASCIIString();
        this.charset = charset;
    }

    @Deprecated
    public QueryStringDecoder(URI uri, String charset) {
        this(uri, Charset.forName(charset));
    }

    public String getPath() {
        if (this.path == null) {
            int pathEndPos = this.uri.indexOf(63);
            if (pathEndPos < 0) {
                this.path = this.uri;
            } else {
                this.path = this.uri.substring(0, pathEndPos);
                return this.path;
            }
        }
        return this.path;
    }

    public Map<String, List<String>> getParameters() {
        if (this.params == null) {
            int pathLength = this.getPath().length();
            if (this.uri.length() == pathLength) {
                return Collections.emptyMap();
            }
            this.params = this.decodeParams(this.uri.substring(pathLength + 1));
        }
        return this.params;
    }

    private Map<String, List<String>> decodeParams(String s) {
        int i;
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        char c = '\u0000';
        for (i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = QueryStringDecoder.decodeComponent(s.substring(pos, i), this.charset);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (name == null && pos != i) {
                QueryStringDecoder.addParam(params, QueryStringDecoder.decodeComponent(s.substring(pos, i), this.charset), "");
            } else if (name != null) {
                QueryStringDecoder.addParam(params, name, QueryStringDecoder.decodeComponent(s.substring(pos, i), this.charset));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                QueryStringDecoder.addParam(params, QueryStringDecoder.decodeComponent(s.substring(pos, i), this.charset), "");
            } else {
                QueryStringDecoder.addParam(params, name, QueryStringDecoder.decodeComponent(s.substring(pos, i), this.charset));
            }
        } else if (name != null) {
            QueryStringDecoder.addParam(params, name, "");
        }
        return params;
    }

    private static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }

    private static void addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
    }
}

