/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.keygenerator.uuid;

import java.net.InetAddress;
import java.security.SecureRandom;
import org.jboss.as.cmp.keygenerator.KeyGenerator;

public class UUIDKeyGenerator
implements KeyGenerator {
    SecureRandom seeder;
    private String midValue;

    public UUIDKeyGenerator() throws Exception {
        StringBuffer buffer = new StringBuffer(16);
        byte[] addr = InetAddress.getLocalHost().getAddress();
        buffer.append(this.toHex(UUIDKeyGenerator.toInt(addr), 8));
        buffer.append(this.toHex(System.identityHashCode(this), 8));
        this.midValue = buffer.toString();
        this.seeder = new SecureRandom();
        int node = this.seeder.nextInt();
    }

    @Override
    public Object generateKey() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(this.toHex((int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL), 8));
        buffer.append(this.midValue);
        buffer.append(this.toHex(this.seeder.nextInt(), 8));
        return buffer.toString();
    }

    private String toHex(int value, int length) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buffer = new StringBuffer(length);
        int shift = length - 1 << 2;
        int i = -1;
        while (++i < length) {
            buffer.append(hexDigits[value >> shift & 0xF]);
            value <<= 4;
        }
        return buffer.toString();
    }

    private static int toInt(byte[] bytes) {
        int value = 0;
        int i = -1;
        while (++i < bytes.length) {
            value <<= 8;
            int b = bytes[i] & 0xFF;
            value |= b;
        }
        return value;
    }
}

