/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jgroups.Message;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class AckReceiverWindow {
    private final AtomicLong next_to_remove;
    private final AtomicBoolean processing = new AtomicBoolean(false);
    private final ConcurrentMap<Long, Segment> segments = Util.createConcurrentMap();
    private volatile Segment current_segment = null;
    private volatile Segment current_remove_segment = null;
    private final int segment_capacity;
    private long highest_segment_created = 0L;
    public static final Message TOMBSTONE = new Message(false){

        @Override
        public String toString() {
            return "tombstone";
        }
    };

    public AckReceiverWindow(long initial_seqno) {
        this(initial_seqno, 1000);
    }

    public AckReceiverWindow(long initial_seqno, int segment_capacity) {
        Segment initial_segment;
        this.next_to_remove = new AtomicLong(initial_seqno);
        this.segment_capacity = segment_capacity;
        long index = this.next_to_remove.get() / (long)segment_capacity;
        long first_seqno = this.next_to_remove.get() / (long)segment_capacity * (long)segment_capacity;
        this.segments.put(index, new Segment(first_seqno, segment_capacity));
        this.current_segment = initial_segment = this.findOrCreateSegment(this.next_to_remove.get());
        this.current_remove_segment = initial_segment;
        for (long i = 0L; i < this.next_to_remove.get(); ++i) {
            initial_segment.add(i, TOMBSTONE);
            initial_segment.remove(i);
        }
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public boolean add(long seqno, Message msg) {
        return this.add2(seqno, msg) == 1;
    }

    public byte add2(long seqno, Message msg) {
        Segment segment = this.current_segment;
        if (!(segment != null && segment.contains(seqno) || (segment = this.findOrCreateSegment(seqno)) == null)) {
            this.current_segment = segment;
        }
        if (segment == null) {
            return -1;
        }
        return segment.add(seqno, msg);
    }

    public Message remove() {
        long next = this.next_to_remove.get();
        Segment segment = this.current_remove_segment;
        if (!(segment != null && segment.contains(next) || (segment = this.findSegment(next)) == null)) {
            this.current_remove_segment = segment;
        }
        if (segment == null) {
            return null;
        }
        Message retval = segment.remove(next);
        if (retval != null) {
            this.next_to_remove.compareAndSet(next, next + 1L);
            if (segment.allRemoved()) {
                this.segments.remove(next / (long)this.segment_capacity);
            }
        }
        return retval;
    }

    public Tuple<List<Message>, Long> removeMany(int max) {
        LinkedList<Message> list = null;
        Tuple retval = null;
        int count = 0;
        boolean looping = true;
        block0: while (count < max && looping) {
            long next = this.next_to_remove.get();
            Segment segment = this.current_remove_segment;
            if (!(segment != null && segment.contains(next) || (segment = this.findSegment(next)) == null)) {
                this.current_remove_segment = segment;
            }
            if (segment == null) {
                return retval;
            }
            long segment_id = next;
            long end = segment.getEndIndex();
            while (next < end && count < max) {
                Message msg = segment.remove(next);
                if (msg == null) {
                    looping = false;
                    continue block0;
                }
                if (list == null) {
                    list = new LinkedList<Message>();
                    retval = new Tuple(list, 0L);
                }
                list.add(msg);
                ++count;
                retval.setVal2(next);
                if (this.next_to_remove.compareAndSet(next, next + 1L)) {
                    ++next;
                }
                if (!segment.allRemoved()) continue;
                this.segments.remove(segment_id / (long)this.segment_capacity);
            }
        }
        return retval;
    }

    public List<Message> removeManyAsList(int max) {
        Tuple<List<Message>, Long> tuple = this.removeMany(max);
        return tuple != null ? tuple.getVal1() : null;
    }

    public void reset() {
        this.segments.clear();
    }

    public int size() {
        int retval = 0;
        for (Segment segment : this.segments.values()) {
            retval += segment.size();
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.size();
        sb.append(size + " messages");
        if (size <= 100) {
            sb.append(" in " + this.segments.size() + " segments");
        }
        return sb.toString();
    }

    public String printMessages() {
        StringBuilder sb = new StringBuilder();
        LinkedList keys = new LinkedList(this.segments.keySet());
        Collections.sort(keys);
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            long key = (Long)i$.next();
            Segment segment = (Segment)this.segments.get(key);
            if (segment == null) continue;
            for (long i = segment.getStartIndex(); i < segment.getEndIndex(); ++i) {
                Message msg = segment.get(i);
                if (msg == null) continue;
                if (msg == TOMBSTONE) {
                    sb.append("T ");
                    continue;
                }
                sb.append(i + " ");
            }
        }
        return sb.toString();
    }

    private Segment findOrCreateSegment(long seqno) {
        long index = seqno / (long)this.segment_capacity;
        if (index > this.highest_segment_created) {
            long start_seqno = seqno / (long)this.segment_capacity * (long)this.segment_capacity;
            Segment segment = new Segment(start_seqno, this.segment_capacity);
            Segment tmp = this.segments.putIfAbsent(index, segment);
            if (tmp != null) {
                segment = tmp;
            } else {
                this.highest_segment_created = index;
            }
            return segment;
        }
        return (Segment)this.segments.get(index);
    }

    private Segment findSegment(long seqno) {
        long index = seqno / (long)this.segment_capacity;
        return (Segment)this.segments.get(index);
    }

    private static class Segment {
        final long start_index;
        final int capacity;
        final AtomicReferenceArray<Message> array;
        final AtomicInteger num_tombstones = new AtomicInteger(0);

        public Segment(long start_index, int capacity) {
            this.start_index = start_index;
            this.capacity = capacity;
            this.array = new AtomicReferenceArray(capacity);
        }

        public long getStartIndex() {
            return this.start_index;
        }

        public long getEndIndex() {
            return this.start_index + (long)this.capacity;
        }

        public boolean contains(long seqno) {
            return seqno >= this.start_index && seqno < this.getEndIndex();
        }

        public Message get(long seqno) {
            int index = this.index(seqno);
            if (index < 0 || index >= this.array.length()) {
                return null;
            }
            return this.array.get(index);
        }

        public byte add(long seqno, Message msg) {
            int index = this.index(seqno);
            if (index < 0) {
                return -1;
            }
            boolean success = this.array.compareAndSet(index, null, msg);
            if (success) {
                return 1;
            }
            return 0;
        }

        public Message remove(long seqno) {
            int index = this.index(seqno);
            if (index < 0) {
                return null;
            }
            Message retval = this.array.get(index);
            if (retval != null && retval != TOMBSTONE && this.array.compareAndSet(index, retval, TOMBSTONE)) {
                this.num_tombstones.incrementAndGet();
                return retval;
            }
            return null;
        }

        public boolean allRemoved() {
            return this.num_tombstones.get() >= this.capacity;
        }

        public String toString() {
            return this.start_index + " - " + (this.start_index + (long)this.capacity - 1L) + " (" + this.size() + " elements)";
        }

        public int size() {
            int retval = 0;
            for (int i = 0; i < this.capacity; ++i) {
                Message tmp = this.array.get(i);
                if (tmp == null || tmp == TOMBSTONE) continue;
                ++retval;
            }
            return retval;
        }

        private int index(long seqno) {
            if (seqno < this.start_index) {
                return -1;
            }
            int index = (int)(seqno - this.start_index);
            if (index < 0 || index >= this.capacity) {
                throw new IndexOutOfBoundsException("index=" + index + ", start_index=" + this.start_index + ", seqno=" + seqno);
            }
            return index;
        }
    }
}

