/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class KerberosConfiguration
extends Configuration {
    public static final String WSC_CONFIGURATION = "com.sun.identity.wss.webservicesclient";
    public static final String WSP_CONFIGURATION = "com.sun.identity.wss.webservicesprovider";
    private static final String kerberosModuleName = "com.sun.security.auth.module.Krb5LoginModule";
    private Configuration config = null;
    private String servicePrincipal = null;
    private String keytab = null;
    private String refreshConf = "false";
    private String ticketCacheDir = null;

    public KerberosConfiguration(Configuration config) {
        this.config = config;
    }

    public void setPrincipalName(String principalName) {
        this.servicePrincipal = principalName;
    }

    public void setKeyTab(String keytabFile) {
        this.keytab = keytabFile;
    }

    public void setRefreshConfig(String refresh) {
        this.refreshConf = refresh;
    }

    public void setTicketCacheDir(String dirName) {
        this.ticketCacheDir = dirName;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (appName.equals(WSC_CONFIGURATION)) {
            HashMap<String, String> hashmap = new HashMap<String, String>();
            hashmap.put("doNotPrompt", "true");
            hashmap.put("useTicketCache", "true");
            hashmap.put("ticketCache", this.ticketCacheDir);
            hashmap.put("refreshKrb5Config", this.refreshConf);
            hashmap.put("debug", "true");
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(kerberosModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashmap);
            return new AppConfigurationEntry[]{appConfigurationEntry};
        }
        if (appName.equals(WSP_CONFIGURATION)) {
            HashMap<String, String> hashmap = new HashMap<String, String>();
            hashmap.put("storeKey", "true");
            hashmap.put("principal", this.servicePrincipal);
            hashmap.put("useKeyTab", "true");
            hashmap.put("keyTab", this.keytab);
            hashmap.put("doNotPrompt", "true");
            hashmap.put("debug", "true");
            hashmap.put("refreshKrb5Config", this.refreshConf);
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(kerberosModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashmap);
            return new AppConfigurationEntry[]{appConfigurationEntry};
        }
        return this.config.getAppConfigurationEntry(appName);
    }

    public void refresh() {
        this.config.refresh();
    }
}

