/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.ws.spi.Provider;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.NonSpringBusHolder;
import org.jboss.wsf.stack.cxf.configuration.SpringBusHolder;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.resolver.JBossWSResourceResolver;
import org.jboss.wsf.stack.cxf.transport.SoapTransportFactoryExt;

public final class BusDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        if (BusFactory.getDefaultBus((boolean)false) == null) {
            JBossWSBusFactory.getDefaultBus((ClassLoader)Provider.provider().getClass().getClassLoader());
        }
        this.startDeploymentBus(dep);
    }

    public void stop(Deployment dep) {
        BusHolder holder = (BusHolder)dep.removeAttachment(BusHolder.class);
        if (holder != null) {
            holder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDeploymentBus(Deployment dep) {
        BusFactory.setThreadDefaultBus(null);
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            ArchiveDeployment aDep = (ArchiveDeployment)dep;
            ResourceResolver deploymentResolver = aDep.getResourceResolver();
            JBossWSResourceResolver resolver = new JBossWSResourceResolver(deploymentResolver);
            Map contextParams = (Map)dep.getProperty("stack.context.parameters");
            String jbosswsCxfXml = contextParams == null ? null : (String)contextParams.get("jbossws.cxf.beans.url");
            BusHolder holder = null;
            SecurityActions.setContextClassLoader((ClassLoader)new DelegateClassLoader(dep.getRuntimeClassLoader(), origClassLoader));
            if (jbosswsCxfXml != null) {
                URL cxfServletUrl = BusDeploymentAspect.getResourceUrl(deploymentResolver, "WEB-INF/cxf-servlet.xml", false);
                URL jbosswsCxfUrl = BusDeploymentAspect.getResourceUrl(deploymentResolver, jbosswsCxfXml, true);
                holder = new SpringBusHolder(cxfServletUrl, jbosswsCxfUrl);
            } else {
                DDBeans metadata = (DDBeans)dep.getAttachment(DDBeans.class);
                holder = new NonSpringBusHolder(metadata);
            }
            Configurer configurer = holder.createServerConfigurer((BindingCustomization)dep.getAttachment(BindingCustomization.class), new WSDLFilePublisher(aDep), dep.getService().getEndpoints(), aDep.getRootFile());
            holder.configure(new SoapTransportFactoryExt(), resolver, configurer, dep);
            dep.addAttachment(BusHolder.class, (Object)holder);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
            SecurityActions.setContextClassLoader(origClassLoader);
        }
    }

    private static URL getResourceUrl(ResourceResolver resolver, String resourcePath, boolean fail) {
        try {
            return resolver.resolve(resourcePath);
        }
        catch (IOException e) {
            if (fail) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

