/*
 * Decompiled with CFR 0.152.
 */
package org.uddi.v3_service;

import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import javax.xml.bind.JAXBException;
import javax.xml.soap.Detail;
import javax.xml.ws.WebFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.uddi.api_v3.DispositionReport;

@WebFault(name="dispositionReport", targetNamespace="urn:uddi-org:api_v3")
public class DispositionReportFaultMessage
extends RemoteException {
    private static final long serialVersionUID = -3901821587689888649L;
    private static transient Log log = LogFactory.getLog(DispositionReportFaultMessage.class);
    private DispositionReport faultInfo;

    public DispositionReportFaultMessage(String message, DispositionReport faultInfo) {
        super(message);
        this.faultInfo = faultInfo;
    }

    public DispositionReportFaultMessage(String message, DispositionReport faultInfo, Throwable cause) {
        super(message, cause);
        this.faultInfo = faultInfo;
    }

    public DispositionReport getFaultInfo() {
        return this.faultInfo;
    }

    public static DispositionReport getDispositionReport(Exception e) {
        DispositionReport report = null;
        if (e instanceof DispositionReportFaultMessage) {
            DispositionReportFaultMessage faultMsg = (DispositionReportFaultMessage)e;
            report = faultMsg.getFaultInfo();
        } else if (e instanceof SOAPFaultException) {
            SOAPFaultException soapFault = (SOAPFaultException)e;
            Detail detail = soapFault.getFault().getDetail();
            if (detail != null && detail.getFirstChild() != null) {
                try {
                    report = new DispositionReport(detail.getFirstChild());
                }
                catch (JAXBException je) {
                    log.error((Object)"Could not unmarshall detail to a DispositionReport");
                }
            }
        } else if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException ute = (UndeclaredThrowableException)e;
            if (ute.getUndeclaredThrowable() != null && ute.getUndeclaredThrowable().getCause() != null && ute.getUndeclaredThrowable().getCause().getCause() instanceof DispositionReportFaultMessage) {
                DispositionReportFaultMessage faultMsg = (DispositionReportFaultMessage)ute.getUndeclaredThrowable().getCause().getCause();
                report = faultMsg.getFaultInfo();
            }
        } else {
            log.error((Object)("Unsupported Exception: " + e.getClass()));
        }
        return report;
    }
}

