/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.addressing.map;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.jboss.ws.api.addressing.MAPRelatesTo;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.stack.cxf.extensions.addressing.map.CXFMAPBuilder;
import org.jboss.wsf.stack.cxf.extensions.addressing.map.CXFMAPEndpoint;
import org.w3c.dom.Element;

public class CXFMAP
implements MAP {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CXFMAP.class);
    private AddressingProperties implementation;

    CXFMAP(AddressingProperties implementation) {
        this.implementation = implementation;
    }

    public String getTo() {
        AttributedURIType to = this.implementation.getTo();
        return to != null ? to.getValue() : null;
    }

    public MAPEndpoint getFrom() {
        EndpointReferenceType from = this.implementation.getFrom();
        return from != null ? new CXFMAPEndpoint(from) : null;
    }

    public String getMessageID() {
        AttributedURIType messageId = this.implementation.getMessageID();
        return messageId != null ? messageId.getValue() : null;
    }

    public String getAction() {
        AttributedURIType action = this.implementation.getAction();
        return action != null ? action.getValue() : null;
    }

    public MAPEndpoint getFaultTo() {
        EndpointReferenceType faultTo = this.implementation.getFaultTo();
        return faultTo != null ? new CXFMAPEndpoint(faultTo) : null;
    }

    public MAPEndpoint getReplyTo() {
        EndpointReferenceType replyTo = this.implementation.getReplyTo();
        return replyTo != null ? new CXFMAPEndpoint(replyTo) : null;
    }

    public MAPRelatesTo getRelatesTo() {
        MAPBuilder builder = CXFMAPBuilder.getBuilder();
        RelatesToType relatesTo = this.implementation.getRelatesTo();
        if (relatesTo != null) {
            QName relatesToType;
            String type = relatesTo.getRelationshipType();
            int index = type.indexOf("}");
            if (index == -1) {
                relatesToType = new QName(type);
            } else {
                String ns = type.substring(1, index + 1);
                String name = type.substring(index + 1);
                relatesToType = new QName(ns, name);
            }
            return builder.newRelatesTo(relatesTo.getValue(), relatesToType);
        }
        return null;
    }

    public void setTo(String address) {
        if (address != null) {
            EndpointReferenceType epref = new EndpointReferenceType();
            AttributedURIType uri = new AttributedURIType();
            uri.setValue(address);
            epref.setAddress(uri);
            this.implementation.setTo(epref);
        } else {
            this.implementation.setTo((EndpointReferenceType)null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFrom(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof CXFMAPEndpoint)) throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
            this.implementation.setFrom(((CXFMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setFrom(null);
        }
    }

    public void setMessageID(String messageID) {
        if (messageID != null) {
            AttributedURIType uri = new AttributedURIType();
            uri.setValue(messageID);
            this.implementation.setMessageID(uri);
        } else {
            this.implementation.setMessageID(null);
        }
    }

    public void setAction(String action) {
        if (action != null) {
            AttributedURIType uri = new AttributedURIType();
            uri.setValue(action);
            this.implementation.setAction(uri);
        } else {
            this.implementation.setAction(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setReplyTo(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof CXFMAPEndpoint)) throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
            this.implementation.setReplyTo(((CXFMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setReplyTo(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFaultTo(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof CXFMAPEndpoint)) throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
            this.implementation.setFaultTo(((CXFMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setFaultTo(null);
        }
    }

    public void setRelatesTo(MAPRelatesTo relatesTo) {
        if (relatesTo != null) {
            RelatesToType relatesToImpl = new RelatesToType();
            relatesToImpl.setValue(relatesTo.getRelatesTo());
            relatesToImpl.setRelationshipType(relatesTo.getType().toString());
            this.implementation.setRelatesTo(relatesToImpl);
        } else {
            this.implementation.setRelatesTo(null);
        }
    }

    public void addReferenceParameter(Element refParam) {
        EndpointReferenceType eprt = this.implementation.getToEndpointReference();
        ReferenceParametersType refParams = eprt.getReferenceParameters();
        if (refParams == null) {
            refParams = new ReferenceParametersType();
            eprt.setReferenceParameters(refParams);
        }
        eprt.getReferenceParameters().getAny().add(refParam);
    }

    public void initializeAsDestination(MAPEndpoint epref) {
        if (epref == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NULL_ENDPOINT_REFERENCE", (Object[])new Object[0]));
        }
        if (!(epref instanceof CXFMAPEndpoint)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAPENDPOINT", (Object[])new Object[]{epref}));
        }
        this.implementation.setTo(((CXFMAPEndpoint)epref).getImplementation());
    }

    public List<Object> getReferenceParameters() {
        List any;
        LinkedList<Object> list = new LinkedList<Object>();
        ReferenceParametersType refParams = this.implementation.getToEndpointReference().getReferenceParameters();
        if (refParams != null && (any = refParams.getAny()) != null) {
            list.addAll(any);
        }
        return list;
    }

    public void installOutboundMapOnClientSide(Map<String, Object> requestContext, MAP map) {
        if (!(map instanceof CXFMAP)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAP", (Object[])new Object[]{map}));
        }
        AddressingProperties addressingProperties = ((CXFMAP)map).implementation;
        requestContext.put("javax.xml.ws.addressing.context", addressingProperties);
        requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProperties);
    }

    public void installOutboundMapOnServerSide(Map<String, Object> requestContext, MAP map) {
        if (!(map instanceof CXFMAP)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_MAP", (Object[])new Object[]{map}));
        }
        AddressingProperties addressingProperties = ((CXFMAP)map).implementation;
        requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProperties);
    }
}

